/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db.hibernate;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.usertype.UserType;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentType
implements UserType {
    static final int[] SQL_TYPES = new int[]{2005};

    @Override
    public boolean equals(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        if (!(x instanceof Document) || !(y instanceof Document)) {
            return x.equals(y);
        }
        return XmlUtil.toString((Document)x).equals(XmlUtil.toString((Document)y));
    }

    @Override
    public int hashCode(Object x) {
        return x.hashCode();
    }

    @Override
    public Object deepCopy(Object value) {
        if (value != null) {
            return XmlUtil.getDocumentFromString(XmlUtil.toString((Node)value));
        }
        return null;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Serializable disassemble(Object value) {
        if (value != null) {
            return XmlUtil.toString((Node)value);
        }
        return null;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) {
        if (cached == null) {
            return null;
        }
        return XmlUtil.getDocumentFromString((String)((Object)cached));
    }

    @Override
    public Object replace(Object original, Object target, Object owner) {
        return this.deepCopy(original);
    }

    @Override
    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        Object object;
        String columnName = names[0];
        Reader reader = null;
        try {
            reader = rs.getCharacterStream(columnName);
            if (reader == null) {
                Object var6_6 = null;
                return var6_6;
            }
            byte[] bytes = Misc.getAllContentFrom(reader);
            object = this.assemble((Serializable)((Object)new String(bytes)), owner);
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return object;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        if (value == null) {
            st.setNull(index, SQL_TYPES[0]);
        } else {
            Node node = (Node)value;
            String valueAsString = XmlUtil.toString(node);
            StringReader sr = new StringReader(valueAsString);
            st.setCharacterStream(index, (Reader)sr, valueAsString.length());
        }
    }

    @Override
    public Class<Document> returnedClass() {
        return Document.class;
    }
}

