/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.svc;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.svc.AsyncCommandMessage;
import org.ow2.orchestra.pvm.session.MessageSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncCommandService
implements CommandService {
    protected boolean propagateUserId = true;

    @Override
    public <T> T execute(Command<T> command) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new PvmException("no environment for verifying authorization");
        }
        MessageSession messageSession = environment.get(MessageSession.class);
        if (messageSession == null) {
            throw new PvmException("no message session for executing command asynchronously");
        }
        String userId = this.propagateUserId ? environment.getUserId() : null;
        messageSession.send(new AsyncCommandMessage(command, userId));
        return null;
    }

    public void setPropagateUserId(boolean propagateUserId) {
        this.propagateUserId = propagateUserId;
    }
}

