/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.def;

import junit.framework.Assert;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.jmx.ManagementAPIImpl;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.services.def.AbstractProcessDefinitionVersioningTest;
import org.ow2.orchestra.util.EnvTool;

public class JournalProcessDefinitionVersioningTest
extends AbstractProcessDefinitionVersioningTest {
    public JournalProcessDefinitionVersioningTest() {
        super(BpelTestCase.EnvironmentType.JOURNAL);
    }

    public Querier getQuerier() {
        return EnvTool.getJournalQueriers();
    }

    public void testProcessDefinitionState() throws ProcessNotFoundException {
        ProcessDefinition pd = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessFullDefinition processFullDefinition = (ProcessFullDefinition)commandService.execute((Command)new AbstractProcessDefinitionVersioningTest.GetProcessDefinitionCmd(pd));
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullDefinition.getType());
        Assert.assertEquals((Object)ProcessState.ACTIVE, (Object)processFullDefinition.getState());
        Assert.assertEquals((int)1, (int)processFullDefinition.getStateUpdates().size());
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        managementAPI.retire(pd.getUUID());
        processFullDefinition = (ProcessFullDefinition)commandService.execute((Command)new AbstractProcessDefinitionVersioningTest.GetProcessDefinitionCmd(pd));
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullDefinition.getType());
        Assert.assertEquals((Object)ProcessState.RETIRED, (Object)processFullDefinition.getState());
        Assert.assertEquals((int)2, (int)processFullDefinition.getStateUpdates().size());
        managementAPI.activate(pd.getUUID());
        processFullDefinition = (ProcessFullDefinition)commandService.execute((Command)new AbstractProcessDefinitionVersioningTest.GetProcessDefinitionCmd(pd));
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullDefinition.getType());
        Assert.assertEquals((Object)ProcessState.ACTIVE, (Object)processFullDefinition.getState());
        Assert.assertEquals((int)3, (int)processFullDefinition.getStateUpdates().size());
        managementAPI.undeploy(pd.getUUID());
        processFullDefinition = (ProcessFullDefinition)commandService.execute((Command)new AbstractProcessDefinitionVersioningTest.GetProcessDefinitionCmd(pd));
        Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullDefinition.getType());
        Assert.assertEquals((Object)ProcessState.UNDEPLOYED, (Object)processFullDefinition.getState());
        Assert.assertEquals((int)4, (int)processFullDefinition.getStateUpdates().size());
    }
}

