/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.axis.WebServiceClassLoader;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

public final class ClassLoaderMap {
    private static Map<String, WebServiceClassLoader> classLoaders = new HashMap<String, WebServiceClassLoader>();

    private ClassLoaderMap() {
    }

    public static WebServiceClassLoader getCL(String endpointName) {
        if (classLoaders == null) {
            return null;
        }
        WebServiceClassLoader result = classLoaders.get(endpointName);
        if (result == null) {
            throw new OrchestraRuntimeException("No service with url " + endpointName + " exists in ClassLoaderMap");
        }
        return result;
    }

    public static void addCL(String endpointName, WebServiceClassLoader cl) {
        classLoaders.put(endpointName, cl);
    }

    public static void removeCL(String endpointName) {
        classLoaders.remove(endpointName);
    }
}

