/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetProcessInstanceCommand
implements Command<ProcessInstance> {
    private static final long serialVersionUID = -4838390493941979414L;
    private final ProcessInstanceUUID processInstanceUUID;

    public GetProcessInstanceCommand(ProcessInstanceUUID processInstanceUUID) {
        this.processInstanceUUID = processInstanceUUID;
    }

    @Override
    public ProcessInstance execute(Environment environment) {
        Querier querier = EnvTool.getQuerier();
        ProcessFullInstance processFullInstance = querier.getProcessInstance(this.processInstanceUUID);
        if (processFullInstance == null) {
            throw new OrchestraWrapperException(new InstanceNotFoundException(this.processInstanceUUID));
        }
        return (ProcessInstance)processFullInstance.copy();
    }
}

