/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.lang.jaxen;

import java.util.Set;
import org.jaxen.JaxenException;
import org.jaxen.XPathSyntaxException;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.PathExpr;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.lang.JoinCondition;
import org.ow2.orchestra.lang.PropertyQuery;
import org.ow2.orchestra.lang.VariableQuery;
import org.ow2.orchestra.lang.evaluator.EvaluatorFactory;
import org.ow2.orchestra.lang.evaluator.ExpressionEvaluator;
import org.ow2.orchestra.lang.evaluator.PropertyQueryEvaluator;
import org.ow2.orchestra.lang.evaluator.VariableQueryEvaluator;
import org.ow2.orchestra.lang.jaxen.ExprVisitor;
import org.ow2.orchestra.lang.jaxen.SetNamespaceContext;
import org.ow2.orchestra.lang.jaxen.XPathExpressionEvaluator;
import org.ow2.orchestra.lang.jaxen.XPathJoinConditionEvaluator;
import org.ow2.orchestra.lang.jaxen.XPathPropertyQueryEvaluator;
import org.ow2.orchestra.lang.jaxen.XPathVariableQueryEvaluator;
import org.ow2.orchestra.util.Namespace;

public class XPathEvaluatorFactory
extends EvaluatorFactory {
    private static final XPathEvaluatorFactory INSTANCE = new XPathEvaluatorFactory();

    public static EvaluatorFactory getInstance() {
        return INSTANCE;
    }

    public ExpressionEvaluator createEvaluator(Expression expression) {
        XPathExpressionEvaluator evaluator;
        String text = expression.getText();
        try {
            evaluator = expression instanceof JoinCondition ? XPathEvaluatorFactory.createJoinConditionEvaluator(text) : XPathEvaluatorFactory.createExpressionEvaluator(text);
        }
        catch (JaxenException e) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.subLanguageExecutionFault, "could not create evaluator for expression: " + expression, e);
        }
        Set<Namespace> namespaces = expression.getNamespaces();
        if (namespaces != null) {
            evaluator.setNamespaceContext(new SetNamespaceContext(namespaces));
        }
        return evaluator;
    }

    public PropertyQueryEvaluator createEvaluator(PropertyQuery query) {
        XPathPropertyQueryEvaluator evaluator;
        try {
            evaluator = XPathEvaluatorFactory.createPropertyQueryEvaluator(query.getText());
        }
        catch (JaxenException e) {
            throw new OrchestraRuntimeException("could not create evaluator for query: " + query, e);
        }
        Set<Namespace> namespaces = query.getNamespaces();
        if (namespaces != null) {
            evaluator.setNamespaceContext(new SetNamespaceContext(namespaces));
        }
        return evaluator;
    }

    public VariableQueryEvaluator createEvaluator(VariableQuery query) {
        XPathVariableQueryEvaluator evaluator;
        try {
            evaluator = XPathEvaluatorFactory.createVariableQueryEvaluator(query.getText());
        }
        catch (JaxenException e) {
            throw new OrchestraRuntimeException("could not create evaluator for query: " + query, e);
        }
        Set<Namespace> namespaces = query.getNamespaces();
        if (namespaces != null) {
            evaluator.setNamespaceContext(new SetNamespaceContext(namespaces));
        }
        return evaluator;
    }

    static XPathExpressionEvaluator createExpressionEvaluator(String text) throws JaxenException {
        XPathExpressionEvaluator expression = new XPathExpressionEvaluator(text);
        if (!new ExprValidator().validate(expression.getRootExpr())) {
            throw new XPathSyntaxException(text, 0, "illegal access to root/context node");
        }
        return expression;
    }

    static XPathJoinConditionEvaluator createJoinConditionEvaluator(String text) throws JaxenException {
        XPathJoinConditionEvaluator joinCondition = new XPathJoinConditionEvaluator(text);
        if (!new ExprValidator().validate(joinCondition.getRootExpr())) {
            throw new XPathSyntaxException(text, 0, "illegal access to root/context node");
        }
        return joinCondition;
    }

    static XPathVariableQueryEvaluator createVariableQueryEvaluator(String text) throws JaxenException {
        return new XPathVariableQueryEvaluator(text);
    }

    static XPathPropertyQueryEvaluator createPropertyQueryEvaluator(String text) throws JaxenException {
        return new XPathPropertyQueryEvaluator(text);
    }

    private static class ExprValidator
    extends ExprVisitor {
        private boolean valid;

        private ExprValidator() {
        }

        public boolean validate(Expr expr) {
            this.valid = true;
            this.visit(expr);
            return this.valid;
        }

        public void visit(PathExpr expr) {
            this.visit(expr.getFilterExpr());
        }

        public void visit(LocationPath locationPath) {
            this.valid = false;
        }
    }
}

