/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.ForEach;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ForeachActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.ForeachActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.CompletionConditionDefinitionImpl;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.IfBinding;
import org.ow2.orchestra.parsing.binding.ScopeBinding;
import org.ow2.orchestra.parsing.binding.exception.DuplicateVariableException;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class ForEachBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(IfBinding.class.getName());

    public ForEachBinding() {
        super("forEach", ActivityType.FOR_EACH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        ForEach forEach = new ForEach();
        NodeImpl forEachNode = this.createActivityNode(element, parse, parser, (ExternalActivity)forEach);
        this.setEnclosingScope(forEach, parse);
        this.parseStandardAttributes(element, forEach, parse);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ForeachActivityFullDefinition foreachActivityFullDefinition = (ForeachActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
        this.parseStandardElements(element, forEach, parse);
        parse.pushObject(forEachNode);
        parse.pushObject(forEach);
        try {
            List<Element> activityElements;
            Boolean successfulBranchesOnly;
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            boolean parallel = BpelUtil.booleanValue(XmlUtil.attribute(element, "parallel"), false);
            forEach.setParallel(parallel);
            forEach.setCounterName(XmlUtil.attribute(element, "counterName"));
            boolean startConstant = false;
            boolean finalConstant = false;
            int constantStartValue = -1;
            int constantFinalValue = -1;
            Element startCounterValueElement = XmlUtil.element(element, "startCounterValue");
            String startCounterValueSt = startCounterValueElement.getTextContent();
            String startCounterValueLanguage = XmlUtil.attribute(startCounterValueElement, "expressionLanguage");
            if (startCounterValueLanguage == null) {
                startCounterValueLanguage = bpelProcess.getExpressionLanguage();
            }
            foreachActivityFullDefinition.setStartCounterExpressionLanguage(startCounterValueLanguage);
            foreachActivityFullDefinition.setStartCounterExpression(startCounterValueSt);
            Expression startCounterValueExpression = new Expression();
            startCounterValueExpression.setLanguage(startCounterValueLanguage);
            startCounterValueExpression.setNamespaces(BpelUtil.getAllNameSpaces(startCounterValueElement));
            startCounterValueExpression.setText(startCounterValueSt);
            try {
                if (startCounterValueSt.length() != 0) {
                    constantStartValue = startCounterValueExpression.getEvaluator().evaluateUnsignedInt(null);
                }
                startConstant = true;
            }
            catch (BpelFaultException e) {
                if (e.getFaultName().equals(BpelFaultException.BpelFault.invalidExpressionValue.getQName()) && e.getMessage() != null && (e.getMessage().equals("Should be an Unsigned Integer expression that conforms to xsd:unsignedInt") || e.getMessage().equals("Should be an Unsigned Integer expression that conforms to xsd:unsignedInt and got NaN"))) {
                    startConstant = true;
                } else {
                    log.finest("startCounterValueSt is not constant");
                }
            }
            catch (Exception e) {
                log.finest("startCounterValueSt is not constant");
            }
            if (startConstant && constantStartValue < 0) {
                String message = StaticAnalysisFault.getMessage("SA00074", "Invalid startCounterValue");
                parse.addProblem(message, new StaticAnalysisException("SA00074"));
            }
            forEach.setStartCounterValue(startCounterValueExpression);
            Element finalCounterValueElement = XmlUtil.element(element, "finalCounterValue");
            String finalCounterValueSt = finalCounterValueElement.getTextContent();
            String finalCounterValueLanguage = XmlUtil.attribute(finalCounterValueElement, "expressionLanguage");
            if (finalCounterValueLanguage == null) {
                finalCounterValueLanguage = bpelProcess.getExpressionLanguage();
            }
            foreachActivityFullDefinition.setFinalCounterExpressionLanguage(finalCounterValueLanguage);
            foreachActivityFullDefinition.setFinalCounterExpression(finalCounterValueSt);
            Expression finalCounterValueExpression = new Expression();
            finalCounterValueExpression.setLanguage(finalCounterValueLanguage);
            finalCounterValueExpression.setNamespaces(BpelUtil.getAllNameSpaces(finalCounterValueElement));
            finalCounterValueExpression.setText(finalCounterValueSt);
            try {
                if (finalCounterValueSt.length() != 0) {
                    constantFinalValue = finalCounterValueExpression.getEvaluator().evaluateUnsignedInt(null);
                }
                finalConstant = true;
            }
            catch (Exception e) {
                log.finest("finalCounterValueSt is not constant");
            }
            if (finalConstant && constantFinalValue < 0) {
                String message = StaticAnalysisFault.getMessage("SA00074", "Invalid finalCounterValue");
                parse.addProblem(message, new StaticAnalysisException("SA00074"));
            }
            forEach.setFinalCounterValue(finalCounterValueExpression);
            Element completionConditionElement = XmlUtil.element(element, "completionCondition");
            if (completionConditionElement != null) {
                Element branchesElement = XmlUtil.element(completionConditionElement, "branches");
                if (branchesElement == null) {
                    parse.addWarning("Completion condition does not contain a \"branches\" node. It will be ignored.");
                } else {
                    successfulBranchesOnly = BpelUtil.booleanValue(XmlUtil.attribute(branchesElement, "successfulBranchesOnly"));
                    if (successfulBranchesOnly != null) {
                        forEach.setSuccessfulBranchesOnly(successfulBranchesOnly);
                    }
                    String completionConditionSt = branchesElement.getTextContent();
                    String completionConditionLanguage = XmlUtil.attribute(branchesElement, "expressionLanguage");
                    if (completionConditionLanguage == null) {
                        completionConditionLanguage = bpelProcess.getExpressionLanguage();
                    }
                    Expression completionCondition = new Expression();
                    completionCondition.setLanguage(completionConditionLanguage);
                    completionCondition.setNamespaces(BpelUtil.getAllNameSpaces(branchesElement));
                    completionCondition.setText(completionConditionSt);
                    if (startConstant && finalConstant) {
                        boolean branchesConstant = false;
                        int constantBranchesValue = -1;
                        try {
                            constantBranchesValue = completionCondition.getEvaluator().evaluateUnsignedInt(null);
                            branchesConstant = true;
                        }
                        catch (Exception e) {
                            log.finest("completionConditionSt is not constant");
                        }
                        if (branchesConstant && Math.max(constantFinalValue - constantStartValue + 1, 0) < constantBranchesValue) {
                            String message = StaticAnalysisFault.getMessage("SA00075", "branches value is larger than number of directly enclosed activities");
                            parse.addProblem(message, new StaticAnalysisException("SA00075"));
                        }
                    }
                    forEach.setCompletionCondition(completionCondition);
                    CompletionConditionDefinitionImpl completionConditionDefinition = new CompletionConditionDefinitionImpl(completionCondition.getText(), completionCondition.getLanguage(), forEach.isSuccessfulBranchesOnly());
                    foreachActivityFullDefinition.setCompletionConditionDefintion(completionConditionDefinition);
                }
            }
            if ((activityElements = XmlUtil.elementsQName(element, Collections.singleton(new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", "scope")))).size() == 0) {
                parse.addProblem("No scope was specified under this foreach element.");
                successfulBranchesOnly = null;
                return successfulBranchesOnly;
            }
            Element childrenElement = activityElements.get(0);
            Variable variable = new Variable();
            variable.setName(forEach.getCounterName());
            variable.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt"));
            variable.initDefaultValue(parse.findObject(BpelProcess.class).getWsdlInfos());
            ScopeBinding binding = (ScopeBinding)parser.getBinding(childrenElement, "activities");
            try {
                definitionKeeper.pushParent();
                binding.parse(childrenElement, Collections.singleton(variable), parse, parser);
            }
            catch (DuplicateVariableException e) {
                String message = StaticAnalysisFault.getMessage("SA00076", "enclosed scope declare a variable with counterName of foreach activity");
                parse.addProblem(message, new StaticAnalysisException("SA00076"));
            }
            finally {
                definitionKeeper.popParent();
            }
        }
        finally {
            parse.popObject();
            parse.popObject();
        }
        foreachActivityFullDefinition.setCounterName(forEach.getCounterName());
        foreachActivityFullDefinition.setParallelValue(forEach.isParallel());
        return forEachNode;
    }

    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new ForeachActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

