/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.cmd;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.ProcessDefinition;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.deploy.DeployerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployCmd
implements Command<ProcessDefinition> {
    private static final long serialVersionUID = 1L;
    protected Deployment deployment;

    public DeployCmd(Deployment deployment) {
        this.deployment = deployment;
    }

    @Override
    public ProcessDefinition execute(Environment environment) {
        ProcessDefinition processDefinition = this.deployment.getProcessDefinition();
        if (processDefinition != null) {
            DeployerManager deployerManager = environment.get(DeployerManager.class);
            if (deployerManager == null) {
                throw new PvmException("no " + DeployerManager.class.getName() + " configured");
            }
            deployerManager.deploy(this.deployment);
        }
        return processDefinition;
    }
}

