/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.job;

import org.hibernate.Query;
import org.hibernate.Session;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.job.TimerImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.ExecuteJobCmd;
import org.ow2.orchestra.pvm.job.Job;

public class JobTestHelper {
    private CommandService commandService;

    public Long getAvailableMessages() {
        return this.commandService.execute(new Command<Long>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Long execute(Environment environment) {
                Session session = environment.get(Session.class);
                Query query = session.createQuery("select count(m) from " + MessageImpl.class.getName() + " as m ");
                Long messageNb = (Long)query.uniqueResult();
                return messageNb;
            }
        });
    }

    public Execution executeMessage(final long executionDbid) {
        return this.commandService.execute(new Command<Execution>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Execution execute(Environment environment) {
                Session session = environment.get(Session.class);
                Query query = session.createQuery("select m from " + MessageImpl.class.getName() + " as m " + "where m.execution.dbid = :executionDbid");
                query.setLong("executionDbid", executionDbid);
                query.setMaxResults(1);
                MessageImpl messageDbid = (MessageImpl)query.uniqueResult();
                ExecuteJobCmd executeJobCommand = new ExecuteJobCmd(messageDbid);
                Job job = executeJobCommand.execute(environment);
                return job.getExecution();
            }
        });
    }

    public Execution executeTimer(final long timerDbid) {
        return this.commandService.execute(new Command<Execution>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Execution execute(Environment environment) {
                Session session = environment.get(Session.class);
                Query query = session.createQuery("select t from " + TimerImpl.class.getName() + " as t " + "where t.dbid = :timerDbid");
                query.setLong("timerDbid", timerDbid);
                query.setMaxResults(1);
                TimerImpl timerDbid2 = (TimerImpl)query.uniqueResult();
                ExecuteJobCmd executeJobCommand = new ExecuteJobCmd(timerDbid2);
                Job job = executeJobCommand.execute(environment);
                return job.getExecution();
            }
        });
    }
}

