/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.IAbstractActivity;
import org.ow2.orchestra.definition.activity.IAbstractBpelActivity;
import org.ow2.orchestra.definition.activity.IScope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.MessageCarrierRepository;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.services.ResultIterator;
import org.ow2.orchestra.services.impl.ReplierImpl;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.wsdl.PropertyAlias;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Receiver {
    private static Logger log = Logger.getLogger(Receiver.class.getName());

    protected Receiver() {
    }

    static ExecElementToSignal findMessageForExecution(BpelExecution execution) {
        if (execution == null || execution.isFinished() || !execution.hasWaitingExecution()) {
            return null;
        }
        WaitingExecution waitingExecution = execution.getWaitingExecution();
        for (ReceivingElement receivingElement : waitingExecution.getInboundMessageElement().getReceivingElements()) {
            PendingMessage pendingMessage = Receiver.getMessageFromStoredMessage(receivingElement, waitingExecution, execution.getProcessDefinition());
            if (pendingMessage == null) continue;
            Receiver.removePendingMessage(pendingMessage);
            return new ExecElementToSignal(execution, receivingElement, pendingMessage);
        }
        return null;
    }

    static ExecElementToSignal associatePendingMessage(PendingMessage pendingMessage, BpelProcess bpelProcess, OperationKey operationKey, Date parentInstanceStartTime) {
        ExecElementToSignal execElementToSignal = null;
        InboundMessageElement startActivity = bpelProcess.getStartElement(operationKey);
        List<ReceivingElement> receivingElements = bpelProcess.getReceivingElements(operationKey);
        if (startActivity == null || bpelProcess.getNumberOfStartElements() > 1 || receivingElements.size() > 1) {
            execElementToSignal = Receiver.getWaitingExecution(pendingMessage, receivingElements, bpelProcess);
        }
        if (execElementToSignal != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Matching execution found for incoming msg: " + execElementToSignal.getBpelExecution());
            }
            return execElementToSignal;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("no matching execution found for pending msg.");
        }
        return null;
    }

    static ExecElementToSignal startNewInstance(PendingMessage pendingMessage, BpelProcess bpelProcess, OperationKey operationKey, Date parentInstanceStartTime) {
        Object execElementToSignal = null;
        InboundMessageElement startActivity = bpelProcess.getStartElement(operationKey);
        if (startActivity != null) {
            ExecElementToSignal receiveExecution;
            ReceivingElement startElement = null;
            for (ReceivingElement receivingElement : startActivity.getReceivingElements()) {
                if (!receivingElement.getOperationKey().equals(operationKey)) continue;
                startElement = receivingElement;
            }
            if (startElement == null) {
                throw new IllegalStateException("No start element found");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("found start node " + startElement + " for incoming msg");
            }
            if ((receiveExecution = Receiver.createNewInstance(pendingMessage, bpelProcess, startActivity, startElement, parentInstanceStartTime)) == null) {
                throw new OrchestraRuntimeException("No waiting execution found !, process = " + bpelProcess.getQName());
            }
            return receiveExecution;
        }
        return null;
    }

    private static ExecElementToSignal createNewInstance(PendingMessage pendingMessage, BpelProcess bpelProcess, InboundMessageElement startActivity, ReceivingElement startElement, Date parentInstanceStartTime) {
        BpelExecution bpelExecution = (BpelExecution)bpelProcess.createProcessInstance();
        HashMap<String, Object> additionnalVariables = new HashMap<String, Object>();
        IScope processActivity = (IScope)bpelProcess.getInitial().getBehaviour();
        if (startElement.getVariable() != null) {
            Variable var = ((IAbstractBpelActivity)((Object)startActivity)).getEnclosingScope().findVariable(startElement.getVariable());
            Variable var1 = processActivity.getVariable(startElement.getVariable());
            if (var1.equals(var)) {
                additionnalVariables.put(startElement.getVariable(), pendingMessage.getMessage().duplicate());
            }
        } else {
            for (Copy copy : startElement.getInCopies()) {
                Variable var = ((IAbstractBpelActivity)((Object)startActivity)).getEnclosingScope().findVariable(copy.getTo().getVariable());
                Variable var1 = processActivity.getVariable(copy.getTo().getVariable());
                if (!var1.equals(var)) continue;
                additionnalVariables.put(copy.getTo().getVariable(), pendingMessage.getMessage().getPartValue(copy.getFrom().getPart()));
            }
        }
        if (!additionnalVariables.isEmpty()) {
            bpelExecution.createVariable("additionnalScopeVariables", additionnalVariables);
        }
        if (parentInstanceStartTime != null) {
            bpelExecution.setParentInstanceStartTime(parentInstanceStartTime);
        }
        bpelExecution.begin();
        return Receiver.getStartElementExecution(bpelExecution, startElement, pendingMessage);
    }

    public static void addReplier(BpelExecution bpelExecution, ReceivingElement receivingElement, MessageCarrier messageCarrier) {
        if (messageCarrier != null) {
            String messageExchange = receivingElement.getMessageExchange();
            ReplierKey replierKey = new ReplierKey(receivingElement.getOperationKey(), messageExchange, bpelExecution.getCurrentScopeRuntime());
            Replier replier = Receiver.createReplier(replierKey);
            MessageCarrierRepository.addMessageCarrier(replierKey, messageCarrier);
            bpelExecution.addReplier(replier);
        }
    }

    private static ExecElementToSignal getWaitingExecution(PendingMessage pendingMessage, List<ReceivingElement> receivingElements, BpelProcess bpelProcess) {
        MessageVariable incomingMessage = pendingMessage.getMessage();
        for (ReceivingElement receivingElement : receivingElements) {
            if (receivingElement.getCorrelations() == null || receivingElement.getCorrelations().isEmpty()) {
                WaitingExecution waitingExecution = EnvTool.getRepository().getFirstWaitingExecution(receivingElement.getInboundMessageElement());
                if (waitingExecution == null) continue;
                ExecElementToSignal res = new ExecElementToSignal(waitingExecution.getBpelExecution(), receivingElement, pendingMessage);
                return res;
            }
            Map<QName, Document> messageProperties = Receiver.getCSPropertiesFromMessage(incomingMessage, receivingElement, bpelProcess);
            ResultIterator<WaitingExecution> waitingExecutions = EnvTool.getRepository().getWaitingExecutions(receivingElement, messageProperties);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Waiting executions for receiving element " + receivingElement + ": " + waitingExecutions);
            }
            WaitingExecution waitingExecution = waitingExecutions.next();
            while (waitingExecution != null) {
                if (Receiver.csMatch(incomingMessage, receivingElement, waitingExecution, bpelProcess)) {
                    ExecElementToSignal res = new ExecElementToSignal(waitingExecution.getBpelExecution(), receivingElement, pendingMessage);
                    return res;
                }
                waitingExecution = waitingExecutions.next();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("No waiting executions for Receiver: " + pendingMessage.getOperationKey());
        }
        return null;
    }

    private static ExecElementToSignal getStartElementExecution(BpelExecution parent, ReceivingElement startElement, PendingMessage pendingMessage) {
        if (parent == null) {
            return null;
        }
        BpelExecution instance = parent.getProcessInstance();
        BpelProcess bpelProcess = instance.getProcessDefinition();
        Set<BpelExecution> waitingExec = instance.searchWaitingExecutions();
        if (log.isLoggable(Level.FINE)) {
            log.fine(Receiver.class + ".getStartElementExecution, execution = " + parent + " waiting=" + waitingExec);
        }
        ExecElementToSignal res = null;
        if (waitingExec != null) {
            for (BpelExecution child : waitingExec) {
                IAbstractActivity activity = (IAbstractActivity)child.getNode().getBehaviour();
                if (!activity.isInboundMessageElement() || !((InboundMessageElement)((Object)activity)).getReceivingElements().contains(startElement)) continue;
                if (bpelProcess.getCommonCorrelationSets() != null) {
                    for (CorrelationSet cs : bpelProcess.getCommonCorrelationSets()) {
                        ReceivingElementUtil.initiateCs(startElement, child, cs, pendingMessage.getMessage());
                    }
                }
                return new ExecElementToSignal(child, startElement, pendingMessage, true);
            }
        }
        return res;
    }

    static PendingMessage storeIncomingMessage(MessageVariable message, MessageCarrier messageCarrier, OperationKey operationKey) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Incoming msg: " + message);
        }
        PendingMessage pendingMessage = null;
        if (messageCarrier != null) {
            MessageCarrierRepository.addPendingMessageCarrier(messageCarrier);
            pendingMessage = new PendingMessage(message, messageCarrier.getUuid(), operationKey);
        } else {
            pendingMessage = new PendingMessage(message, null, operationKey);
        }
        return pendingMessage;
    }

    protected static void storePendingMessage(PendingMessage pendingMessage) {
        EnvTool.getRepository().storePendingMessage(pendingMessage);
    }

    static boolean csMatch(MessageVariable messageToAnalyse, ReceivingElement receivingElement, WaitingExecution waitingExecution, BpelProcess bpelProcess) {
        if (receivingElement.getCorrelations() == null) {
            return true;
        }
        for (Correlation correlation : receivingElement.getCorrelations()) {
            if (correlation.correlationOK(messageToAnalyse, receivingElement, waitingExecution, bpelProcess)) continue;
            return false;
        }
        return true;
    }

    private static Map<QName, Document> getCSPropertiesFromMessage(MessageVariable message, ReceivingElement receivingElement, BpelProcess bpelProcess) {
        if (receivingElement.getCorrelations() == null) {
            return Collections.emptyMap();
        }
        HashMap<QName, Document> properties = new HashMap<QName, Document>();
        QName messageType = receivingElement.getInputMessageType();
        for (Correlation correlation : receivingElement.getCorrelations()) {
            if (!correlation.getInitiate().equals((Object)Correlation.Initiate.no) && !correlation.getInitiate().equals((Object)Correlation.Initiate.join)) continue;
            List<PropertyAlias> propertyAliases = correlation.getCorrelationSet().getPropertyAliasRefs(bpelProcess.getWsdlInfos(), messageType);
            for (PropertyAlias propertyAlias : propertyAliases) {
                Node value = propertyAlias.getPropertyValueFromMessage(message);
                Element el = XmlUtil.getDocumentWithOneElement(new QName("http://orchestra.ow2.org", "ORCHESTRA_anonymous_element"));
                el.appendChild(el.getOwnerDocument().importNode(value, true));
                properties.put(propertyAlias.getPropertyName(), el.getOwnerDocument());
            }
        }
        return properties;
    }

    private static PendingMessage getMessageFromStoredMessage(ReceivingElement receivingElement, WaitingExecution waitingExecution, BpelProcess bpelProcess) {
        ResultIterator<PendingMessage> pendingMessages = EnvTool.getRepository().getPendingMessages(receivingElement.getOperationKey());
        PendingMessage pendingMessage = pendingMessages.next();
        while (pendingMessage != null) {
            MessageVariable message = pendingMessage.getMessage();
            if (Receiver.csMatch(message, receivingElement, waitingExecution, bpelProcess)) {
                return pendingMessage;
            }
            pendingMessage = pendingMessages.next();
        }
        return null;
    }

    public static void removePendingMessage(PendingMessage pendingMessage) {
        EnvTool.getRepository().removePendingMessage(pendingMessage);
    }

    public static void deletePendingMessage(PendingMessage pendingMessage) {
        EnvTool.getRepository().removePendingMessage(pendingMessage);
        if (pendingMessage.getMessageCarrierId() != null) {
            MessageCarrierRepository.throwMissingReply(pendingMessage.getMessageCarrierId());
        }
    }

    private static Replier createReplier(ReplierKey replierKey) {
        return new ReplierImpl(replierKey);
    }
}

