/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test;

import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.hibernate.SessionFactory;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.Statistics;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.EnvFactoryRepository;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;

public abstract class EnvironmentTestCase
extends TestCase {
    private static final Logger LOG = Logger.getLogger(EnvironmentTestCase.class.getName());
    private boolean createdEnvFactory = false;

    protected EnvironmentTestCase() {
        EnvironmentTestCase.setSystemProperties();
    }

    public static DefaultEnvXMLGenerator getBpelTestEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.NO_JOURNAL);
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        return envGenerator;
    }

    public DefaultEnvXMLGenerator getEnvGenerator() {
        return EnvironmentTestCase.getBpelTestEnvGenerator();
    }

    public synchronized EnvironmentFactory getEnvironmentFactory() {
        if (EnvFactoryRepository.get() == null) {
            try {
                DefaultEnvXMLGenerator envGenerator = this.getEnvGenerator();
                EnvFactoryRepository.set(envGenerator.createEnvironmentFactory());
                this.createdEnvFactory = true;
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
        return EnvFactoryRepository.get();
    }

    protected void tearDown() throws Exception {
        if (this.createdEnvFactory) {
            EnvFactoryRepository.get().close();
            EnvFactoryRepository.set(null);
        }
        LOG.info("=== ending " + this.getName() + " =============================\n");
        super.tearDown();
    }

    public void setUp() throws Exception {
        LOG.info("=== starting " + this.getName() + " =============================");
    }

    public static void setSystemProperty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    public static void setSystemProperties() {
        EnvironmentTestCase.setSystemProperty("javax.xml.stream.XMLEventFactory", "com.ctc.wstx.stax.WstxEventFactory");
        EnvironmentTestCase.setSystemProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        EnvironmentTestCase.setSystemProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
    }

    public void beginCacheTest() {
        SessionFactory sessionFactory = (SessionFactory)this.getEnvironmentFactory().get(SessionFactory.class);
        if (sessionFactory != null) {
            LOG.info("=================================================================");
            LOG.info("Beginning of the cache test, no more sql query should be performed before the end of the test");
            LOG.info("=================================================================");
            sessionFactory.getStatistics().clear();
            sessionFactory.getStatistics().setStatisticsEnabled(true);
        }
    }

    public void endCacheTest() {
        Statistics stats;
        SessionFactory sessionFactory = (SessionFactory)this.getEnvironmentFactory().get(SessionFactory.class);
        if (sessionFactory != null && (stats = sessionFactory.getStatistics()) != null) {
            String[] entities;
            String[] collections;
            for (String collection : collections = stats.getCollectionRoleNames()) {
                CollectionStatistics collectionStatistics = stats.getCollectionStatistics(collection);
                if (collection.startsWith("org.ow2.orchestra.runtime") || collection.startsWith("org.ow2.orchestra.service") || collection.startsWith("org.ow2.orchestra.pvm.internal.job") || collection.startsWith("org.ow2.orchestra.facade")) continue;
                Assert.assertEquals((String)(collection + ": " + collectionStatistics.getLoadCount() + " loads"), (long)0L, (long)collectionStatistics.getLoadCount());
            }
            for (String entity : entities = stats.getEntityNames()) {
                EntityStatistics entityStatistics = stats.getEntityStatistics(entity);
                if (entity.startsWith("org.ow2.orchestra.runtime") || entity.startsWith("org.ow2.orchestra.service") || entity.equals("org.ow2.orchestra.definition.BpelProcess$InstanceCreationLock") || entity.startsWith("org.ow2.orchestra.pvm.internal.job") || entity.startsWith("org.ow2.orchestra.facade")) continue;
                Assert.assertEquals((String)(entity + ": " + entityStatistics.getLoadCount() + " loads"), (long)0L, (long)entityStatistics.getLoadCount());
            }
            System.out.println(stats.getTransactionCount() + " transactions.");
            System.out.println(stats.getEntityInsertCount() + " insert.");
            System.out.println(stats.getEntityUpdateCount() + " updates.");
        }
    }
}

