/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.eventHandlers.onAlarm;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class OnAlarmTest
extends BpelTestCase {
    private final long time = 5L;

    public OnAlarmTest() {
        super("http://orchestra.ow2.org/OnAlarmTest", "OnAlarmTest");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public BpelTestCase.CallResult launch(String message, SaveWS saveWS) {
        return this.launch(message, saveWS, this.time);
    }

    public BpelTestCase.CallResult launch(String message, SaveWS saveWS, long alarmTime) {
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + alarmTime + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "OnAlarmTestOperation";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "OnAlarmTestOperation");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        ProcessInstanceUUID processInstanceUUID = (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){

            public ProcessInstanceUUID execute(Environment environment) {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
        return callResult;
    }

    private void deleteInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                OnAlarmTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public void testOnAlarmEvent() {
        this.deploy();
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message + message;
        SaveWS saveWS = new SaveWS();
        BpelTestCase.CallResult result = this.launch(message, saveWS);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    public void testWaitForEndedEvent() {
        this.deploy(((Object)((Object)this)).getClass().getResource("OnAlarm2Test.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message + message;
        SaveWS saveWS = new SaveWS();
        BpelTestCase.CallResult result = this.launch(message, saveWS);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    public void testEndedEvent() {
        this.deploy(((Object)((Object)this)).getClass().getResource("OnAlarm3Test.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        BpelTestCase.CallResult result = this.launch(message, saveWS);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    public void testOnAlarmProcessVariableEvent() {
        this.deploy(((Object)((Object)this)).getClass().getResource("OnAlarm4Test.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message;
        SaveWS saveWS = new SaveWS();
        BpelTestCase.CallResult result = this.launch(message, saveWS, 1L);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
    }

    public void testOnAlarmProcessVariableEvent2() {
        String message;
        this.deploy(((Object)((Object)this)).getClass().getResource("OnAlarm4Test.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String expectedResponse = message = UUID.randomUUID().toString();
        SaveWS saveWS = new SaveWS();
        BpelTestCase.CallResult result = this.launch(message, saveWS, 7L);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
    }

    public void testConcurrentOnAlarmEvent() {
        this.deploy(((Object)((Object)this)).getClass().getResource("OnAlarm5Test.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message + message;
        SaveWS saveWS = new SaveWS();
        BpelTestCase.CallResult result = this.launch(message, saveWS);
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.deleteInstanceMethod(result);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }
}

