/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.test.wsutils.WaitWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public class ForEachWithParallelInvokeTest
extends BpelTestCase {
    public ForEachWithParallelInvokeTest() {
        super("http://orchestra.ow2.org/forEachWithParallelInvokeTest", "forEachWithParallelInvokeTest", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testForEachWithParallelInvoke() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        long timeout = 180000L;
        int finalCounterValue = 10;
        int completionCondition = 2;
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        WaitWS waitWS = new WaitWS();
        WSRepository.addWS(WaitWS.PORTTYPE_QNAME, waitWS);
        try {
            HashMap<String, Element> parts = new HashMap<String, Element>();
            parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
            QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
            final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
            boolean fail = true;
            long startTime = System.currentTimeMillis();
            while (startTime + 180000L > System.currentTimeMillis()) {
                if (waitWS.getQueueLength() < 10) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                fail = false;
                break;
            }
            Assert.assertFalse((String)"Timeout occured", (boolean)fail);
            waitWS.release(2);
            fail = true;
            startTime = System.currentTimeMillis();
            CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
            while (startTime + 180000L > System.currentTimeMillis()) {
                if (((Boolean)commandService.execute((Command)new Command<Boolean>(){

                    public Boolean execute(Environment environment) {
                        Set activityInstances = EnvTool.getQuerier().findActivityInstances(callResult.getProcessInstanceUUID(), ActivityState.RUNNING);
                        for (ActivityFullInstance activity : activityInstances) {
                            ActivityFullDefinition activityDef = EnvTool.getQuerier().getActivityDefinition(activity.getDefinitionUUID());
                            Assert.assertNotNull((String)("No activity definition found for UUID: " + activity.getDefinitionUUID()), (Object)activityDef);
                            if (!"resume".equals(activityDef.getName())) continue;
                            return true;
                        }
                        return false;
                    }
                })).booleanValue()) {
                    fail = false;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Assert.assertFalse((String)"Timeout occured", (boolean)fail);
            this.call(parts, portTypeQName, "resume");
            commandService.execute((Command)new Command<Object>(){

                public Object execute(Environment environment) {
                    ForEachWithParallelInvokeTest.this.deleteInstance(callResult);
                    return null;
                }
            });
            WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
            Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
            Assert.assertEquals((int)8, (int)waitWS.getQueueLength());
        }
        finally {
            waitWS.releaseAll();
        }
    }
}

