/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.addition;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class AdditionTest
extends AbstractPerfTestCase {
    public AdditionTest() {
        super("http://orchestra.ow2.org/addition", "addition");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        final int base = Misc.random((int)0, (int)100000);
        final int toAdd = Misc.random((int)-555, (int)100000);
        parts.put("base", BpelXmlUtil.createElementWithContent((String)Integer.toString(base)));
        parts.put("toAdd", BpelXmlUtil.createElementWithContent((String)Integer.toString(toAdd)));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "add";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "add");
        final MessageVariable reply = callResult.getMessageCarrier().getMessage();
        long endTime = callResult.getEndTime();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                if (reply == null) {
                    throw new OrchestraRuntimeException("reply is null");
                }
                Element element = reply.getPartValue("total");
                if (element == null) {
                    throw new OrchestraRuntimeException("reply.total is null");
                }
                String totalSt = element.getTextContent();
                if (totalSt == null) {
                    throw new OrchestraRuntimeException("reply.total.textContent is null");
                }
                int total = new Integer(totalSt);
                if (total != base + toAdd) {
                    throw new OrchestraRuntimeException("reply.total.textContent is not " + (base + toAdd) + ", it is : " + total);
                }
                AdditionTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    public void testAddition() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testAdditionHibernateCache() {
        this.deploy();
        this.launch();
        this.beginCacheTest();
        this.launch();
        this.endCacheTest();
        this.undeploy();
    }

    public String getAlias() {
        return "class.add";
    }
}

