/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.runtime.FlowRuntime;
import org.ow2.orchestra.runtime.ForEachRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.test.runtime.RuntimeTestCase;
import org.ow2.orchestra.util.Misc;

public class TestBpelExecution
extends RuntimeTestCase {
    private BpelProcess processDefinitionImpl;
    private Node nodeImpl;
    private BpelExecution bpelExecution;

    public void testForEachRuntimePersistence() throws Exception {
        this.verifyPersistence(ForEachRuntime.class);
    }

    public void testScopeRuntimePersistence() throws Exception {
        this.verifyPersistence(ScopeRuntime.class);
    }

    public void testWaitingExecutionPersistence() throws Exception {
        this.verifyPersistence(WaitingExecution.class);
    }

    public void testBpelExecutionPersistence() throws Exception {
        this.nodeImpl = new Node();
        this.nodeImpl.setName(Misc.getRandomString((int)7));
        this.persist(this.nodeImpl);
        this.verifyPersistence(BpelExecution.class);
        this.delete(this.nodeImpl);
    }

    public void testBpelInstancePersistence() throws Exception {
        this.nodeImpl = new Node();
        this.nodeImpl.setName(Misc.getRandomString((int)7));
        this.persist(this.nodeImpl);
        this.verifyPersistence(BpelInstance.class);
        this.delete(this.nodeImpl);
    }

    public boolean shouldExclude(String className, String fieldName) {
        if (className.equals(BpelExecution.class.getName())) {
            if (Arrays.asList("processDefinition", "previousNode", "transition", "transitionOrigin", "previousTransition", "parent", "processInstance", "hasVariables", "variables", "name", "key", "priority", "nextLogIndex", "parentInstanceStartTime", "processUUID", "currentNode").contains(fieldName)) {
                return true;
            }
            if (Arrays.asList("superProcessExecution", "event", "eventSource", "subProcessInstance", "exception", "processModifications", "waitForSignal", "comments", "atomicOperations").contains(fieldName)) {
                return true;
            }
            if (Arrays.asList("forEachRuntime", "scopeRuntime", "flowRuntime", "waitingExecution").contains(fieldName)) {
                return true;
            }
        }
        if (className.equals(WaitingExecution.class.getName()) && Arrays.asList("bpelExecution").contains(fieldName)) {
            return true;
        }
        if (className.equals(ScopeRuntime.class.getName()) && Arrays.asList("scopeDefinition", "catchHasAlreadyBeenMatched", "compensateExecution", "parent").contains(fieldName)) {
            return true;
        }
        if (Arrays.asList(Node.class.getName(), CompositeElement.class.getName()).contains(className)) {
            return true;
        }
        return super.shouldExclude(className, fieldName);
    }

    public Object createCustomReference(String className, String fieldName) {
        if (className.equals(BpelExecution.class.getName())) {
            if (fieldName.equals("processDefinition")) {
                return this.processDefinitionImpl;
            }
            if (Arrays.asList("node", "previousNode").contains(fieldName)) {
                return this.nodeImpl;
            }
            if (Arrays.asList("parent", "processInstance").contains(fieldName)) {
                return this.bpelExecution;
            }
            if (fieldName.equals("executions")) {
                return new ArrayList();
            }
            if (fieldName.equals("variables")) {
                return new HashMap();
            }
            if (fieldName.equals("jobs")) {
                return new ArrayList();
            }
        } else if (className.equals(BpelInstance.class.getName())) {
            if (fieldName.equals("repliers")) {
                return new HashSet();
            }
        } else if (className.equals(FlowRuntime.class.getName())) {
            if (fieldName.equals("linkRuntimes")) {
                return new HashMap();
            }
        } else if (className.equals(ScopeRuntime.class.getName())) {
            if (fieldName.equals("variables")) {
                return new HashMap();
            }
            if (fieldName.equals("partnerLinks")) {
                return new HashMap();
            }
            if (fieldName.equals("correlationSets")) {
                return new HashMap();
            }
            if (fieldName.equals("endedChildren")) {
                return new ArrayList();
            }
        } else if (className.equals(WaitingExecution.class.getName())) {
            if (fieldName.equals("correlationKeys")) {
                return new ArrayList();
            }
            if (fieldName.equals("correlationSetRuntimes")) {
                return new HashSet();
            }
        }
        return null;
    }
}

