/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.TransitionConditionUpdate;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.FlowActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.SequenceActivityFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public abstract class AbstractSubTypesFlowTest
extends BpelTestCase {
    private ProcessInstanceUUID processFullInstanceUUID;

    public abstract Querier getQuerier();

    public AbstractSubTypesFlowTest(BpelTestCase.EnvironmentType environmentType) {
        super("http://orchestra.ow2.org/flow", "flow", environmentType);
    }

    public void testSubtypesTestFlow() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource("subtypestestflow.bpel"), ((Object)((Object)this)).getClass().getResource("subtypestestflow.wsdl"));
    }

    public void launch() {
        int i;
        int callCount = 3;
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "start";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(1)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(3)));
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, operationName);
        this.processFullInstanceUUID = callResult.getProcessInstanceUUID();
        operationName = "initiate";
        for (i = 0; i < 3; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(i)));
            parts.put("id", BpelXmlUtil.createElementWithContent((String)Integer.toString(3 - i)));
            this.call(parts, portTypeQName, operationName);
        }
        operationName = "submit";
        for (i = 0; i < 3; ++i) {
            parts = new HashMap();
            parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)Integer.toString(3 - i - 1)));
            this.call(parts, portTypeQName, operationName);
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                Assert.assertEquals((Object)AbstractSubTypesFlowTest.this.processFullInstanceUUID, (Object)((ProcessFullInstance)processFullInstanceSet.iterator().next()).getUUID());
                return null;
            }
        });
        this.call(parts, portTypeQName, "continue").getMessageCarrier().getMessage();
        callResult.getMessageCarrier().getMessage();
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = AbstractSubTypesFlowTest.this.getQuerier();
                ProcessFullInstance processFullInstance = querier.getProcessInstance(AbstractSubTypesFlowTest.this.processFullInstanceUUID);
                ArrayList<ActivityType> activityTypeDBJournalList = new ArrayList<ActivityType>();
                Assert.assertNotNull((Object)processFullInstance);
                Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullInstance.getType());
                ActivityFullInstance enclosedActivityInstance = processFullInstance.getEnclosedActivity();
                Assert.assertEquals((Object)ActivityType.SEQUENCE, (Object)enclosedActivityInstance.getType());
                SequenceActivityFullInstance sequenceActivityFullInstance = (SequenceActivityFullInstance)enclosedActivityInstance.fullCopy();
                List sequaneceEnclosedActivities = sequenceActivityFullInstance.getEnclosedActivities();
                for (ActivityFullInstance activityFullInstance : sequaneceEnclosedActivities) {
                    activityTypeDBJournalList.add(activityFullInstance.getType());
                    switch (activityFullInstance.getType()) {
                        case FLOW: {
                            AbstractSubTypesFlowTest.this.checkFlow(activityFullInstance);
                            break;
                        }
                    }
                }
                AbstractSubTypesFlowTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public void checkFlow(ActivityFullInstance activityFullInstance) {
        FlowActivityFullInstance flowActivityFullInstance = (FlowActivityFullInstance)activityFullInstance;
        List activityFullInstanceSet = flowActivityFullInstance.getEnclosedActivities();
        Assert.assertTrue((activityFullInstanceSet.size() > 0 ? 1 : 0) != 0);
        for (ActivityFullInstance enclosedActivityFullInstance : activityFullInstanceSet) {
            if (ActivityType.SEQUENCE.equals((Object)enclosedActivityFullInstance.getType())) continue;
            Assert.assertEquals((Object)ActivityType.SCOPE, (Object)enclosedActivityFullInstance.getType());
        }
        List transitionConditionUpdateList = flowActivityFullInstance.getTransitionConditionUpdateList();
        Iterator transitionConditionUpdateIterator = transitionConditionUpdateList.iterator();
        HashSet<String> expectedTransitionUpdates = new HashSet<String>();
        HashSet<String> actualTransitionUpdates = new HashSet<String>();
        int i = 1;
        while (transitionConditionUpdateIterator.hasNext()) {
            TransitionConditionUpdate transitionConditionUpdate = (TransitionConditionUpdate)transitionConditionUpdateIterator.next();
            Assert.assertNotNull((Object)transitionConditionUpdate.getDate());
            expectedTransitionUpdates.add("R" + i + "toFINISH");
            actualTransitionUpdates.add(transitionConditionUpdate.getName());
            Assert.assertTrue((boolean)transitionConditionUpdate.getStatus());
            ++i;
        }
        Assert.assertEquals(expectedTransitionUpdates, actualTransitionUpdates);
    }
}

