/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.message;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class MessageTest
extends BpelTestCase {
    public MessageTest() {
        super("http://example.com/message", "message");
    }

    public void testMessage() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL baseProduct = ((Object)((Object)this)).getClass().getResource("baseProduct.xml");
        this.assertExists(baseProduct);
        URL baseElement = ((Object)((Object)this)).getClass().getResource("baseElement.xml");
        this.assertExists(baseElement);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("product", XmlUtil.getDocumentFromURL((URL)baseProduct).getDocumentElement());
        parts.put("element", XmlUtil.getDocumentFromURL((URL)baseElement).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)6, (int)callResult.getVariables().size());
                MessageTest.this.assertMessage(MessageTest.this.getVariableValue(callResult, "request2"));
                MessageTest.this.assertProduct(MessageTest.this.getVariableValue(callResult, "productPart"));
                MessageTest.this.assertmyElement(MessageTest.this.getVariableValue(callResult, "elementPart"));
                MessageTest.this.assertProduct(MessageTest.this.getVariableValue(callResult, "productPart2"));
                MessageTest.this.assertmyElement(MessageTest.this.getVariableValue(callResult, "elementPart2"));
                MessageTest.this.assertMessage(MessageTest.this.getVariableValue(callResult, "request3"));
                MessageTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertMessage(Object o) {
        Assert.assertTrue((String)"o is not an instance of Message", (boolean)(o instanceof MessageVariable));
        Assert.assertEquals((int)2, (int)((MessageVariable)o).getParts().size());
        Element productPart = ((MessageVariable)o).getPartValue("product");
        this.assertProduct(productPart);
        Element elementPart = ((MessageVariable)o).getPartValue("element");
        this.assertmyElement(elementPart);
    }

    private void assertProduct(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"123", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"chips", (String)root.getAttribute("reference"));
        this.assertElementNSContentAndNoChild(root, "name", "myProduct");
        this.assertElementNSContentAndNoChild(root, "quantity", "52");
    }

    private void assertmyElement(Object o) {
        Element root = this.assertTopElementNS(o, "myElement");
        this.assertElementNSContentAndNoChild(root, "element1.1.1", "HelloWorld");
        this.assertElementNSContentAndNoChild(root, "element1.2", "123");
    }
}

