/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.property;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class PropertyTest
extends BpelTestCase {
    public PropertyTest() {
        super("http://example.com/property", "property");
    }

    public void testProperty() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL creditCardNumber = ((Object)((Object)this)).getClass().getResource("creditCardNumber.xml");
        this.assertExists(creditCardNumber);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("creditCardNumber", XmlUtil.getDocumentFromURL((URL)creditCardNumber).getDocumentElement());
        parts.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"12345"));
        parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)"54321"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)3, (int)callResult.getVariables().size());
                PropertyTest.this.assertRequest(PropertyTest.this.getVariableValue(callResult, "request"));
                PropertyTest.this.assertRequest2(PropertyTest.this.getVariableValue(callResult, "request2"));
                PropertyTest.this.assertString(PropertyTest.this.getVariableValue(callResult, "st"));
                PropertyTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertRequest(Object o) {
        Assert.assertTrue((String)"request is not an instance of Message", (boolean)(o instanceof MessageVariable));
        Assert.assertEquals((int)3, (int)((MessageVariable)o).getParts().size());
        Element shippingCostsPart = ((MessageVariable)o).getPartValue("shippingCosts");
        Assert.assertEquals((String)"54321", (String)shippingCostsPart.getTextContent());
        Element creditCardNumber = ((MessageVariable)o).getPartValue("creditCardNumber");
        Assert.assertNotNull((Object)creditCardNumber);
        Element auctionId = ((MessageVariable)o).getPartValue("auctionId");
        Assert.assertNotNull((Object)auctionId);
    }

    private void assertRequest2(Object o) {
        Assert.assertTrue((String)"request is not an instance of Message", (boolean)(o instanceof MessageVariable));
        Assert.assertEquals((int)3, (int)((MessageVariable)o).getParts().size());
        Element shippingCostsPart = ((MessageVariable)o).getPartValue("shippingCosts");
        Assert.assertEquals((String)"54321", (String)shippingCostsPart.getTextContent());
    }

    private void assertString(Object o) {
        Assert.assertTrue((String)"st is not an instance of Element", (boolean)(o instanceof Element));
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((String)"123", (String)((Element)o).getTextContent());
    }
}

