/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.versioning;

import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.jmx.ManagementAPIImpl;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.if_.IfTest;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class DeployTest
extends BpelTestCase {
    public DeployTest() {
        super("http://orchestra.ow2.org/tests/helloworld", "helloworld");
    }

    public void testDeployAlreadyDeployedProcess() throws TimeoutException {
        ProcessDefinition pd1 = this.deployV1();
        String name = "Dupont";
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        ProcessDefinition pd2 = this.deployV2();
        Assert.assertEquals((String)"Hi Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertEquals((Object)pd1.getQName(), (Object)pd2.getQName());
        Assert.assertFalse((boolean)pd1.getProcessDefinitionUUID().equals((Object)pd2.getProcessDefinitionUUID()));
        Assert.assertEquals((int)(pd1.getVersion() + 1), (int)pd2.getVersion());
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        managementAPI.undeploy(pd2.getProcessDefinitionUUID());
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
    }

    public void testRetireActivateOneProcess() throws TimeoutException, ProcessNotFoundException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        ProcessDefinition pd1 = this.deployV1();
        String name = "Dupont";
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertFalse((boolean)managementAPI.activate(pd1.getProcessDefinitionUUID()));
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertTrue((boolean)managementAPI.retire(pd1.getProcessDefinitionUUID()));
        try {
            Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
            Assert.fail((String)"timeout expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Assert.assertFalse((boolean)managementAPI.retire(pd1.getProcessDefinitionUUID()));
        Assert.assertTrue((boolean)managementAPI.activate(pd1.getProcessDefinitionUUID()));
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
    }

    public void testRetireActivateTwoProcesses() throws TimeoutException, ProcessNotFoundException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        ProcessDefinition pd1 = this.deployV1();
        String name = "Dupont";
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        ProcessDefinition pd2 = this.deployV2();
        Assert.assertEquals((String)"Hi Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertTrue((boolean)managementAPI.activate(pd1.getProcessDefinitionUUID()));
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertTrue((boolean)managementAPI.retire(pd1.getProcessDefinitionUUID()));
        try {
            Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
            Assert.fail((String)"timeout expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        managementAPI.undeploy(pd2.getProcessDefinitionUUID());
        try {
            Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
            Assert.fail((String)"timeout expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
    }

    public void testActivateDuringUndeploy() throws TimeoutException, ProcessNotFoundException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        ProcessDefinition pd1 = this.deployV1();
        String name = "Dupont";
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        ProcessDefinition pd2 = this.deployV2();
        Assert.assertEquals((String)"Hi Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertTrue((boolean)managementAPI.activate(pd1.getProcessDefinitionUUID()));
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
        Assert.assertEquals((String)"Hi Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd2.getProcessDefinitionUUID());
    }

    public void testActivateDuringUndeploy3Versions() throws TimeoutException, ProcessNotFoundException {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        ProcessDefinition pd1 = this.deployV1();
        String name = "Dupont";
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        ProcessDefinition pd2 = this.deployV2();
        Assert.assertEquals((String)"Hi Dupont", (String)this.executeProcess("Dupont"));
        ProcessDefinition pd3 = this.deployV3();
        Assert.assertEquals((String)"Bonjour Dupont", (String)this.executeProcess("Dupont"));
        Assert.assertTrue((boolean)managementAPI.activate(pd1.getProcessDefinitionUUID()));
        Assert.assertEquals((String)"Hello Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd1.getProcessDefinitionUUID());
        Assert.assertEquals((String)"Bonjour Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd3.getProcessDefinitionUUID());
        Assert.assertEquals((String)"Hi Dupont", (String)this.executeProcess("Dupont"));
        managementAPI.undeploy(pd2.getProcessDefinitionUUID());
    }

    public void testActivateBadId() {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        String badId = "bad id";
        try {
            managementAPI.activate(new ProcessDefinitionUUID("bad id"));
        }
        catch (ProcessNotFoundException pnfe) {
            Assert.assertEquals((String)"bad id", (String)pnfe.getProcessUUID().toString());
        }
    }

    public void testRetireBadId() {
        ManagementAPIImpl managementAPI = new ManagementAPIImpl(this.getEnvironmentFactory());
        String badId = "bad id";
        try {
            managementAPI.retire(new ProcessDefinitionUUID("bad id"));
        }
        catch (ProcessNotFoundException pnfe) {
            Assert.assertEquals((String)"bad id", (String)pnfe.getProcessUUID().toString());
        }
    }

    private String executeProcess(String input) throws TimeoutException {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("inputType", BpelXmlUtil.createElementWithContent((String)input));
        QName portTypeQName = new QName(this.getProcessNamespace(), "helloPT");
        String operationName = "sayHello";
        final BpelTestCase.CallResult cr = this.call(parts, portTypeQName, "sayHello");
        MessageVariable result = cr.getMessageCarrier().getMessage(5000L);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                DeployTest.this.deleteInstance(cr);
                return null;
            }
        });
        String resultString = result.getPartValue("resultType").getTextContent();
        return resultString;
    }

    public ProcessDefinition deployV1() {
        return this.deploy(DeployTest.class.getResource(this.getProcessName() + "-v1.bpel"), IfTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public ProcessDefinition deployV2() {
        return this.deploy(DeployTest.class.getResource(this.getProcessName() + "-v2.bpel"), IfTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public ProcessDefinition deployV3() {
        return this.deploy(DeployTest.class.getResource(this.getProcessName() + "-v3.bpel"), IfTest.class.getResource(this.getProcessName() + ".wsdl"));
    }
}

