/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import javax.swing.event.EventListenerList;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;

public abstract class AbstractStore
implements Store {
    private transient EventListenerList listenerList;

    protected synchronized EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public boolean isCacheCoherent() {
        return false;
    }

    public boolean isClusterCoherent() {
        return false;
    }

    public boolean isNodeCoherent() {
        return false;
    }

    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void waitUntilClusterCoherent() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public synchronized void addStoreListener(StoreListener listener) {
        this.removeStoreListener(listener);
        this.getEventListenerList().add(StoreListener.class, listener);
    }

    public synchronized void removeStoreListener(StoreListener listener) {
        this.getEventListenerList().remove(StoreListener.class, listener);
    }

    public void fireNodeCoherent(boolean nodeCoherent) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StoreListener.class) continue;
            ((StoreListener)listeners[i + 1]).nodeCoherent(nodeCoherent);
        }
    }

    public void fireClusterCoherent(boolean clusterCoherent) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StoreListener.class) continue;
            ((StoreListener)listeners[i + 1]).clusterCoherent(clusterCoherent);
        }
    }
}

