/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.ExceptionHandler;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid;
    protected int dbversion;
    protected String name;
    protected String description;
    protected List<Node> nodes;
    protected transient Map<String, Node> nodesMap;
    protected BpelProcess processDefinition;
    protected ExceptionHandler exceptionHandler;

    public Node createNode(ActivityDefinitionUUID nodeUUID) {
        Node node = new Node();
        node.setName(nodeUUID.toString());
        this.addNode(node);
        return node;
    }

    public Node addNode(Node node) {
        node.setProcessDefinition(this.processDefinition);
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
        this.nodesMap = null;
        return node;
    }

    public boolean removeNode(Node node) {
        if (node != null && this.nodes != null) {
            boolean isRemoved = this.nodes.remove(node);
            if (isRemoved) {
                node.setParentNode(null);
                if (this.nodes.isEmpty()) {
                    this.nodes = null;
                }
                this.nodesMap = null;
            }
            return isRemoved;
        }
        return false;
    }

    public Node getNode(String nodeName) {
        return this.getNodesMap() != null ? this.nodesMap.get(nodeName) : null;
    }

    public boolean hasNode(String nodeName) {
        return this.getNodesMap() != null && this.nodesMap.containsKey(nodeName);
    }

    public Node findNode(String nodeName) {
        if (this.nodes != null) {
            for (Node n : this.nodes) {
                Node node = n.findNode(nodeName);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Map<String, Node> getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = Node.getNodesMap(this.getNodes());
        }
        return this.nodesMap;
    }

    public boolean hasNodes() {
        return this.nodes != null && !this.nodes.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getDbid() {
        return this.dbid;
    }

    public BpelProcess getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(BpelProcess processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public CompositeElement getParent() {
        return null;
    }
}

