/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.ExceptionHandlerSynchronization;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.op.MoveToChildNode;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ExceptionHandler.class.getName());
    protected long dbid;
    protected int dbversion;
    protected String exceptionClassName;
    protected boolean isTransactional = false;
    protected boolean isRethrowMasked = false;
    protected String nodeName;

    public boolean matches(Exception exception) {
        return this.matches(exception.getClass());
    }

    public boolean matches(Class<?> exceptionClass) {
        if (exceptionClass == null) {
            return false;
        }
        Class<?> exceptionClassClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), this.exceptionClassName);
        return exceptionClassClass.isAssignableFrom(exceptionClass);
    }

    public void handle(BpelExecution execution, Exception exception, CompositeElement processElementImpl) {
        if (this.isTransactional) {
            Transaction transaction;
            Environment environment = Environment.getCurrent();
            Transaction transaction2 = transaction = environment != null ? environment.get(Transaction.class) : null;
            if (transaction != null) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "registering exception handler to %s", transaction);
                CommandService commandService = environment.get(CommandService.class);
                if (commandService == null) {
                    throw new OrchestraRuntimeException("environment doesn't have a command service for registering transactional exception handler", exception);
                }
                ExceptionHandlerSynchronization exceptionHandlerSynchronization = new ExceptionHandlerSynchronization(this, execution, exception, processElementImpl, commandService);
                exceptionHandlerSynchronization.register(transaction);
                Misc.fastDynamicLog(LOG, Level.FINEST, "registering exception handler to %s", transaction);
                throw new OrchestraRuntimeException("transaction exception handler registered handler after transaction completed.  make sure this transaction is rolled back", exception);
            }
            throw new OrchestraRuntimeException("no transaction present in the environment for transactional exception handler", exception);
        }
        this.executeHandler(execution, exception, processElementImpl);
    }

    protected void executeHandler(BpelExecution execution, Exception exception, CompositeElement processElementImpl) {
        if (this.nodeName != null) {
            execution.waitForSignal();
        }
        Node childNode = null;
        if (processElementImpl != null) {
            childNode = processElementImpl.getNode(this.nodeName);
        }
        if (childNode != null) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "%s executes node %s", this, this.nodeName);
            execution.performAtomicOperation(new MoveToChildNode(childNode));
        } else {
            Misc.fastDynamicLog(LOG, Level.WARNING, "WARNING: %s couldn't find child node %s", this, this.nodeName);
        }
    }

    public static void rethrow(Exception exception, String prefixMessage) {
        Misc.fastDynamicLog(LOG, Level.FINEST, "rethrowing %s", exception);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new OrchestraRuntimeException(prefixMessage + ": " + exception.getMessage(), exception);
    }

    public String toString() {
        return this.exceptionClassName != null ? "exception-handler(" + this.exceptionClassName + ")" : "exception-handler";
    }

    public long getDbid() {
        return this.dbid;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean isRethrowMasked() {
        return this.isRethrowMasked;
    }

    public void setRethrowMasked(boolean isRethrowMasked) {
        this.isRethrowMasked = isRethrowMasked;
    }
}

