/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.ExceptionHandler;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.persistence.db.DbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerSynchronization
implements Synchronization,
Command<Object> {
    private static final Logger LOG = Logger.getLogger(ExceptionHandlerSynchronization.class.getName());
    private final ExceptionHandler exceptionHandler;
    private static final long serialVersionUID = 1L;
    protected BpelExecution execution;
    protected CompositeElement processElement;
    protected Exception exception;
    protected CommandService commandService;

    public ExceptionHandlerSynchronization(ExceptionHandler exceptionHandler, BpelExecution execution, Exception exception, CompositeElement processElement, CommandService commandService) {
        this.exceptionHandler = exceptionHandler;
        this.execution = execution;
        this.exception = exception;
        this.commandService = commandService;
        this.processElement = processElement;
    }

    public void afterCompletion(int status) {
        if (status != 4) {
            Misc.fastDynamicLog(LOG, Level.WARNING, "WARNING: no rollback after transactional exception handler. did you forget to rollback the transaction ?", new Object[0]);
        }
        this.commandService.execute(this);
    }

    @Override
    public Object execute(Environment environment) {
        DbSession dbSession = environment.get(DbSession.class);
        if (dbSession == null) {
            throw new OrchestraRuntimeException("no " + DbSession.class.getName() + " available in the environment for reloading the execution");
        }
        this.execution = dbSession.get(BpelExecution.class, this.execution.getDbid());
        this.exceptionHandler.executeHandler(this.execution, this.exception, this.processElement);
        return null;
    }

    public void beforeCompletion() {
    }

    public void register(Transaction transaction) {
        transaction.registerSynchronization(this);
    }
}

