/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.ExceptionHandler;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultInCHHandler
extends ExceptionHandler {
    private static final long serialVersionUID = 6330814889501735922L;
    private static final Logger LOG = Logger.getLogger(FaultInCHHandler.class.getName());

    @Override
    public boolean matches(Class<?> exceptionClass) {
        return BpelFaultException.class.isAssignableFrom(exceptionClass);
    }

    @Override
    protected void executeHandler(BpelExecution execution, Exception exception, CompositeElement processElementImpl) {
        BpelExecution chBpelExecution;
        Node chNode = (Node)processElementImpl;
        BpelExecution bpelExecution = execution;
        BpelFaultException bpelFault = (BpelFaultException)exception;
        EnvTool.getRecorder().recordExceptionOccured(new BpelFaultData(bpelFault, bpelExecution.getActivityInstanceUUID()));
        for (chBpelExecution = bpelExecution; chBpelExecution != null && chBpelExecution.getNode() != chNode; chBpelExecution = chBpelExecution.getParent()) {
        }
        if (chBpelExecution == null || chBpelExecution.getNode() != chNode) {
            Misc.unreachableStatement("Cannot find the bpelExecution for compensation handler " + chNode);
            return;
        }
        ScopeRuntime scopeRuntime = chBpelExecution.getCurrentScopeRuntime();
        Misc.fastDynamicLog(LOG, Level.FINEST, "Handling exception %s in BpelExecution %s: scopeRuntime state is %s, CHBpelExecution is %s", new Object[]{exception, bpelExecution, scopeRuntime.getState(), chBpelExecution});
        if (!ScopeState.COMPENSATING.equals((Object)scopeRuntime.getState())) {
            Misc.unreachableStatement("The compensation handler " + chNode + " is in invalid state " + (Object)((Object)scopeRuntime.getState()));
        }
        scopeRuntime.setLastException(bpelFault.fullCopy());
        chBpelExecution.terminate();
    }
}

