/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.activity.AbstractActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends CompositeElement {
    private static final long serialVersionUID = 1L;
    protected AbstractActivity behaviourReference;
    protected Node parentNode;

    @Override
    public Node addNode(Node node) {
        node.setParentNode(this);
        super.addNode(node);
        return node;
    }

    @Override
    public Node findNode(String nodeName) {
        if (nodeName == null ? this.name == null : nodeName.equals(this.name)) {
            return this;
        }
        return super.findNode(nodeName);
    }

    public void setBehaviour(AbstractActivity activity) {
        this.behaviourReference = activity;
    }

    public AbstractActivity getBehaviour() {
        return this.behaviourReference;
    }

    static Map<String, Node> getNodesMap(List<Node> nodes) {
        HashMap<String, Node> map = null;
        if (nodes != null) {
            map = new HashMap<String, Node>();
            for (Node node : nodes) {
                if (node.getName() == null || map.containsKey(node.getName())) continue;
                map.put(node.getName(), node);
            }
        }
        return map;
    }

    public String toString() {
        if (this.name != null) {
            return "node(" + this.name + " - " + this.behaviourReference.getName() + ")";
        }
        if (this.dbid != 0L) {
            return "node(" + this.dbid + ")";
        }
        return "node(" + System.identityHashCode(this) + ")";
    }

    public List<CompositeElement> getParentChain() {
        ArrayList<CompositeElement> chain = new ArrayList<CompositeElement>();
        for (CompositeElement processElement = this; processElement != null; processElement = ((CompositeElement)processElement).getParent()) {
            chain.add(processElement);
        }
        return chain;
    }

    @Override
    public CompositeElement getParent() {
        return this.parentNode != null ? this.parentNode : this.processDefinition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.processDefinition == null) {
            this.name = name;
        } else {
            if (this.name != null) {
                this.processDefinition.removeNode(this);
            }
            this.name = name;
            if (name != null) {
                this.processDefinition.addNode(this);
            }
        }
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }
}

