/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.ExceptionHandler;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraFaultHandler
extends ExceptionHandler {
    private static final long serialVersionUID = 6330814889501735922L;
    private static final Logger LOG = Logger.getLogger(OrchestraFaultHandler.class.getName());

    @Override
    public boolean matches(Class<?> exceptionClass) {
        return BpelFaultException.class.isAssignableFrom(exceptionClass);
    }

    @Override
    protected void executeHandler(BpelExecution execution, Exception exception, CompositeElement processElementImpl) {
        BpelExecution scopeBpelExecution;
        Node scope = (Node)processElementImpl;
        BpelExecution bpelExecution = execution;
        BpelFaultException bpelFault = (BpelFaultException)exception;
        EnvTool.getRecorder().recordExceptionOccured(new BpelFaultData(bpelFault, bpelExecution.getActivityInstanceUUID()));
        for (scopeBpelExecution = bpelExecution; scopeBpelExecution != null && scopeBpelExecution.getNode() != scope; scopeBpelExecution = scopeBpelExecution.getParent()) {
        }
        if (scopeBpelExecution == null || scopeBpelExecution.getNode() != scope) {
            Misc.unreachableStatement("Cannot find the scope BpelExecution for scope " + scope);
            return;
        }
        ScopeRuntime scopeRuntime = bpelExecution.getScopeRuntimeWithScope((Scope)scope.getBehaviour());
        Misc.fastDynamicLog(LOG, Level.FINEST, "Handling exception %s in BpelExecution %s: scopeRuntime state is %s, scopeBpelExecution is %s", new Object[]{exception, bpelExecution, scopeRuntime.getState(), scopeBpelExecution});
        if (ScopeState.RUNNING.equals((Object)scopeRuntime.getState())) {
            scopeRuntime.setLastException(bpelFault.fullCopy());
            scopeRuntime.setState(ScopeState.HANDLING_FAULT, bpelExecution);
            scopeBpelExecution.terminate();
        } else if (ScopeState.TERMINATING.equals((Object)scopeRuntime.getState())) {
            scopeRuntime.setState(ScopeState.COMPLETED_UNSUCCESSFUL, bpelExecution);
            scopeBpelExecution.exit();
            if (scopeBpelExecution.getParent() != null) {
                Misc.fastDynamicLog(LOG, Level.FINEST, "Terminating parent %s", scopeBpelExecution.getParent());
                scopeBpelExecution.getParent().terminate();
            }
        } else {
            if (ScopeState.HANDLING_FAULT.equals((Object)scopeRuntime.getState())) {
                scopeRuntime.setState(ScopeState.RETHROWING_FAULT, bpelExecution);
            }
            ExceptionHandler.rethrow(exception, "Rethrown by BpelExecution " + bpelExecution);
        }
    }
}

