/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.ActivityWithSingleChild;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.runtime.ScopeRuntime;

public class CompensationHandlerActivity
extends ActivityWithSingleChild {
    private static final long serialVersionUID = -1532327461542960780L;
    protected boolean isDefaultCH;

    protected CompensationHandlerActivity() {
        super(null, null, null);
    }

    public CompensationHandlerActivity(Node child, ActivityDefinitionUUID uuid, String name, boolean isDefaultCH) {
        super(child, uuid, name);
        this.isDefaultCH = isDefaultCH;
    }

    public void beforeRunning(BpelExecution bpelExecution) {
        super.beforeRunning(bpelExecution);
        ScopeRuntime scopeRuntime = bpelExecution.getCurrentScopeRuntime();
        scopeRuntime.setState(ScopeState.COMPENSATING, bpelExecution);
    }

    public void signal(BpelExecution execution) {
        execution.end(ExecutionState.ended);
        BpelExecution chExecution = execution.getParent();
        chExecution.removeExecution(execution);
        chExecution.end(ExecutionState.ended);
        ScopeRuntime scopeRuntime = chExecution.popScopeRuntime(false);
        scopeRuntime.setState(ScopeState.COMPENSATED, chExecution);
        BpelExecution parentExecution = chExecution.getParent();
        parentExecution.removeExecution(chExecution);
        BpelExecution compensateExecution = scopeRuntime.getCompensateExecution();
        scopeRuntime.setCompensateExecution(null);
        compensateExecution.signal();
    }

    public boolean isDefaultCH() {
        return this.isDefaultCH;
    }

    public ActivityType getType() {
        return ActivityType.COMPENSATION_HANDLER;
    }
}

