/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.OnEvent;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.persistence.db.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.job.ExecuteScopeMessage;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.ow2.orchestra.var.MessageVariable;

public class EventHandlerScope
extends Scope {
    private static final long serialVersionUID = 1907606311898956588L;
    public static final String ON_EVENT = "onEvent";
    public static final String MESSAGE = "message";
    public static final String MESSAGE_CARRIER = "messageCarrier";

    public void beforeRunning(BpelExecution bpelExecution) {
        ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityInstanceUUID(bpelExecution.getProcessInstance().getProcessInstanceUUID());
        bpelExecution.setActivityInstanceUUID(activityInstanceUUID);
        EnvTool.getRecorder().recordEventStarted(this.createRuntimeData(bpelExecution));
    }

    protected void executeEventHandlers(BpelExecution execution) {
        OnEvent onEvent = (OnEvent)execution.getVariable(ON_EVENT);
        if (onEvent != null) {
            MessageCarrier messageCarrier = (MessageCarrier)execution.getVariable(MESSAGE_CARRIER);
            MessageVariable message = (MessageVariable)execution.getVariable(MESSAGE);
            ReceivingElementUtil.receive(onEvent, message, messageCarrier, execution);
        }
        super.executeEventHandlers(execution);
    }

    public void executeMainActivity(BpelExecution execution) {
        OnEvent onEvent = (OnEvent)execution.getVariable(ON_EVENT);
        if (onEvent != null) {
            execution.removeVariable(MESSAGE_CARRIER);
            execution.removeVariable(MESSAGE);
            execution.removeVariable(ON_EVENT);
            Environment.getFromCurrent(MessageSession.class).send(new ExecuteScopeMessage(execution));
            execution.waitForSignal();
            execution.setState(ExecutionState.async);
        } else {
            super.executeMainActivity(execution);
        }
    }
}

