/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.Link;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.runtime.FlowRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    protected Map<String, Link> links = null;

    @Override
    public void executeActivity(BpelExecution execution) {
        execution.pushFlowRuntime(new FlowRuntime(this.links, execution.getActivityInstanceUUID()));
        List<Node> nesteNodes = execution.getNode().getNodes();
        if (nesteNodes != null && !nesteNodes.isEmpty()) {
            HashMap<Node, BpelExecution> childs = new HashMap<Node, BpelExecution>();
            for (Node node : nesteNodes) {
                BpelExecution childExecution = execution.createExecution();
                childs.put(node, childExecution);
            }
            for (Map.Entry entry : childs.entrySet()) {
                ((BpelExecution)entry.getValue()).execute((Node)entry.getKey());
            }
        }
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            execution.end(ExecutionState.ended);
            BpelExecution flowExecution = execution.getParent();
            flowExecution.removeExecution(execution);
            if (flowExecution.isActive()) {
                flowExecution.signal("all-finished");
            }
        } else {
            this.afterRunned(execution);
        }
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public Link getLink(String linkName) {
        if (this.links == null) {
            return null;
        }
        return this.links.get(linkName);
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.FLOW;
    }
}

