/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.Else;
import org.ow2.orchestra.definition.element.Elseif;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class If
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(If.class.getName());
    protected Expression condition;
    protected Node activity;
    protected List<Elseif> elseifs;
    protected Else elseField;

    @Override
    public void executeActivity(BpelExecution execution) {
        boolean ifResult = this.condition.getEvaluator().evaluateBoolean(execution);
        if (ifResult) {
            Misc.fastDynamicLog(LOG, Level.FINE, "if condition : %s evaluated to true", this.condition);
            execution.createExecution().execute(this.activity);
        } else {
            for (Elseif elseif : this.elseifs) {
                boolean elseifResult = elseif.getCondition().getEvaluator().evaluateBoolean(execution);
                if (!elseifResult) continue;
                Misc.fastDynamicLog(LOG, Level.FINE, "elseif condition : %s evaluated to true", elseif.getCondition());
                execution.createExecution().execute(elseif.getActivity());
                return;
            }
            if (this.elseField != null) {
                Misc.fastDynamicLog(LOG, Level.FINE, "Executing else...", new Object[0]);
                execution.createExecution().execute(this.elseField.getActivity());
            } else {
                this.afterRunned(execution);
            }
        }
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            execution.end(ExecutionState.ended);
            BpelExecution ifExecution = execution.getParent();
            ifExecution.removeExecution(execution);
            ifExecution.signal("finished");
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public List<Elseif> getElseifs() {
        return this.elseifs;
    }

    public void setElseifs(List<Elseif> elseifs) {
        this.elseifs = elseifs;
    }

    public Else getElse() {
        return this.elseField;
    }

    public void setElse(Else else1) {
        this.elseField = else1;
    }

    public Node getActivity() {
        return this.activity;
    }

    public void setActivity(Node activity) {
        this.activity = activity;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.IF;
    }
}

