/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.data.def.InvokeActivityDefinitionData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.persistence.db.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.job.ExecuteInvokeJob;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Invoke.class.getName());
    protected String partnerLink;
    protected QName portTypeQName;
    protected String operationName;
    protected String inputVariable;
    protected String outputVariable;
    protected List<Correlation> requestCorrelations = null;
    protected List<Correlation> responseCorrelations = null;
    protected boolean isOneWay;
    protected List<Copy> outCopies;
    protected List<Copy> inCopies;
    protected Variable anonymousOutboundMessageVariable;
    protected Variable anonymousInboundMessageVariable;
    public static final String RECEIVED_MESSAGE = "SIGNAL_PARAMETER_RECEIVED_MSG";
    public static final String RECEIVED_EXCEPTION = "SIGNAL_PARAMETER_RECEIVED_EXCEPTION";

    @Override
    public void executeActivity(BpelExecution execution) {
        PartnerLinkRuntime partnerLinkRuntime = execution.getPartnerLinkRuntime(this.partnerLink);
        OperationKey operationKey = new OperationKey(execution.getProcessDefinition().getQName(), this.portTypeQName, this.operationName);
        ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
        VariableRuntime anonymousOutboundMessageVariableRuntime = scopeRuntime.createVariable(execution, this.anonymousOutboundMessageVariable);
        for (Copy copy : this.outCopies) {
            copy.execute(execution);
        }
        if (this.requestCorrelations != null) {
            for (Correlation correlation : this.requestCorrelations) {
                CorrelationSetRuntime correlationSetRuntime = execution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                correlationSetRuntime.checkCSValues(execution, (MessageVariable)anonymousOutboundMessageVariableRuntime.getValue(), this.anonymousOutboundMessageVariable.getMessageType(), correlation);
            }
        }
        scopeRuntime.removeVariable(execution, this.anonymousOutboundMessageVariable);
        Misc.fastDynamicLog(LOG, Level.FINE, "Invoke, inputMessage %s", anonymousOutboundMessageVariableRuntime.getValue());
        Element partnerRoleElement = partnerLinkRuntime.getPartnerRoleEndPointReference(execution);
        if (partnerRoleElement == null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.uninitializedPartnerRole);
        }
        ExecuteInvokeJob invokeJob = new ExecuteInvokeJob((MessageVariable)anonymousOutboundMessageVariableRuntime.getValue(), partnerRoleElement, operationKey);
        invokeJob.setExecution(execution);
        Environment.getFromCurrent(MessageSession.class).send(invokeJob);
        execution.waitForSignal();
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (parameters.containsKey(RECEIVED_EXCEPTION)) {
            RuntimeException exception = (RuntimeException)parameters.get(RECEIVED_EXCEPTION);
            throw exception;
        }
        if (!this.isOneWay) {
            MessageVariable returnedMessage = (MessageVariable)parameters.get(RECEIVED_MESSAGE);
            Misc.fastDynamicLog(LOG, Level.FINE, "Invoke, returnedMessage %s", returnedMessage);
            ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
            VariableRuntime anonymousInboundMessageVariableRuntime = scopeRuntime.createVariable(execution, this.anonymousInboundMessageVariable);
            anonymousInboundMessageVariableRuntime.setValue(returnedMessage);
            for (Copy copy : this.inCopies) {
                copy.execute(execution);
            }
            scopeRuntime.removeVariable(execution, this.anonymousInboundMessageVariable);
            if (this.responseCorrelations != null) {
                for (Correlation correlation : this.responseCorrelations) {
                    CorrelationSetRuntime correlationSetRuntime = execution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                    correlationSetRuntime.checkCSValues(execution, returnedMessage, this.anonymousInboundMessageVariable.getMessageType(), correlation);
                }
            }
        } else {
            Misc.fastDynamicLog(LOG, Level.FINE, "Invoke one way signalled", new Object[0]);
        }
        this.afterRunned(execution);
    }

    @Override
    public InvokeActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new InvokeActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name);
    }

    public String getInputVariable() {
        return this.inputVariable;
    }

    public void setInputVariable(String inputVariable) {
        this.inputVariable = inputVariable;
    }

    public String getOperation() {
        return this.operationName;
    }

    public void setOperation(String operation) {
        this.operationName = operation;
    }

    public String getOutputVariable() {
        return this.outputVariable;
    }

    public void setOutputVariable(String outputVariable) {
        this.outputVariable = outputVariable;
    }

    public String getPartnerLink() {
        return this.partnerLink;
    }

    public void setPartnerLink(String partnerLink) {
        this.partnerLink = partnerLink;
    }

    public QName getPortTypeQName() {
        return this.portTypeQName;
    }

    public void setPortTypeQName(QName portType) {
        this.portTypeQName = portType;
    }

    public List<Correlation> getRequestCorrelations() {
        return this.requestCorrelations;
    }

    public void setRequestCorrelations(List<Correlation> correlations) {
        this.requestCorrelations = correlations;
    }

    public List<Correlation> getResponseCorrelations() {
        return this.responseCorrelations;
    }

    public void setResponseCorrelations(List<Correlation> correlations) {
        this.responseCorrelations = correlations;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    public void setOneWay(boolean oneWay) {
        this.isOneWay = oneWay;
    }

    public List<Copy> getOutCopies() {
        return this.outCopies;
    }

    public void setOutCopies(List<Copy> outCopies) {
        this.outCopies = outCopies;
    }

    public List<Copy> getInCopies() {
        return this.inCopies;
    }

    public void setInCopies(List<Copy> inCopies) {
        this.inCopies = inCopies;
    }

    public Variable getAnonymousOutboundMessageVariable() {
        return this.anonymousOutboundMessageVariable;
    }

    public void setAnonymousOutboundMessageVariable(Variable anonymousOutboundMessageVariable) {
        this.anonymousOutboundMessageVariable = anonymousOutboundMessageVariable;
    }

    public Variable getAnonymousInboundMessageVariable() {
        return this.anonymousInboundMessageVariable;
    }

    public void setAnonymousInboundMessageVariable(Variable anonymousInboundMessageVariable) {
        this.anonymousInboundMessageVariable = anonymousInboundMessageVariable;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.INVOKE;
    }
}

