/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.CompositeElement;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.facade.data.def.ProcessActivityDefinitionData;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.MessageCarrierRepository;
import org.ow2.orchestra.services.handlers.FinishedInstanceHandler;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Process
extends Scope {
    private static final long serialVersionUID = -375673090384319392L;
    private static final Logger LOG = Logger.getLogger(Process.class.getName());

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            super.signal(execution, null, parameters);
            return;
        }
        this.afterRunned(execution);
        if (execution.isActive()) {
            CompositeElement parent = execution.getNode().getParent();
            if (parent == null) {
                Misc.fastDynamicLog(LOG, Level.FINE, "End of bpel process execution", new Object[0]);
                if (execution.getParent() != null) {
                    throw new IllegalStateException("Child execution reaches the end of process !");
                }
                if (!execution.searchWaitingExecutions().isEmpty()) {
                    throw new IllegalStateException("Execution reaches the end of process, but child executions are still waiting for a trigger !");
                }
                execution.removeJobs();
                execution.end();
            }
            Process.endProcessInstance(execution);
        }
    }

    public static void endProcessInstance(BpelExecution execution) {
        BpelInstance instance = execution.getProcessInstance();
        for (Replier replier : instance.getRepliers()) {
            MessageCarrierRepository.throwMissingReply(replier.getReplierKey());
        }
        FinishedInstanceHandler handler = EnvTool.get(FinishedInstanceHandler.class, "finished-instance-handler");
        if (handler != null) {
            handler.handleFinishedInstance(instance.getProcessInstanceUUID());
        }
    }

    @Override
    public ProcessActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ProcessActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, null);
    }

    @Override
    public void beforeRunning(BpelExecution bpelExecution) {
        BpelInstance bpelInstance = bpelExecution.getProcessInstance();
        ProcessInstanceUUID activityInstanceUUID = bpelInstance.getProcessInstanceUUID();
        bpelExecution.setActivityInstanceUUID(activityInstanceUUID);
        bpelInstance.setProcessInstanceState(ActivityState.RUNNING);
        EnvTool.getRecorder().recordInstanceStarted(bpelInstance.getProcessInstanceData());
    }

    @Override
    public void afterRunned(BpelExecution bpelExecution) {
        BpelInstance bpelInstance = bpelExecution.getProcessInstance();
        bpelInstance.setProcessInstanceState(ActivityState.FINISHED);
        EnvTool.getRecorder().recordInstanceEnded(bpelInstance.getProcessInstanceData());
    }
}

