/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.data.def.RethrowActivityDefinitionData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.Misc;

public class Rethrow
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1859357075672007231L;

    public void executeActivity(BpelExecution execution) {
        ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
        if (scopeRuntime == null) {
            Misc.unreachableStatement("Current ScopeRuntime is null!");
            return;
        }
        if (!ScopeState.HANDLING_FAULT.equals((Object)scopeRuntime.getState())) {
            Misc.unreachableStatement("State is " + (Object)((Object)scopeRuntime.getState()) + ", it should be " + (Object)((Object)ScopeState.HANDLING_FAULT));
            return;
        }
        BpelFaultException lastException = scopeRuntime.getLastException();
        if (lastException == null) {
            Misc.unreachableStatement("LastException is null!");
            return;
        }
        execution.waitForSignal();
        throw lastException;
    }

    public ActivityType getType() {
        return ActivityType.RETHROW;
    }

    public RethrowActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new RethrowActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name);
    }
}

