/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.OnAlarm;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wait
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Wait.class.getName());
    private Expression durationExpression = null;
    private Expression deadlineExpression = null;

    @Override
    public void executeActivity(BpelExecution execution) {
        Date date = OnAlarm.computeTimer(execution, this.deadlineExpression, this.durationExpression, null);
        execution.createTimer("timeout", date, null);
        EnvTool.getRecorder().recordTimerStarted(new TimerData(execution.getActivityInstanceUUID(), null, date));
        execution.waitForSignal();
    }

    public void setDurationExpression(Expression durationExpression) {
        this.durationExpression = durationExpression;
    }

    public void setDeadlineExpression(Expression deadlineExpression) {
        this.deadlineExpression = deadlineExpression;
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        Misc.fastDynamicLog(LOG, Level.FINE, "timer reached execution time at %s", System.currentTimeMillis());
        this.afterRunned(execution);
    }

    @Override
    public ActivityType getType() {
        return ActivityType.WAIT;
    }

    @Override
    public ActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.getType(), this.name);
    }
}

