/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ExecutionState;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class While
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(While.class.getName());
    protected Expression condition;

    @Override
    public void executeActivity(BpelExecution execution) {
        Node node = execution.getNode();
        Node firstNode = node.getNodes().get(0);
        this.executeLoop(execution.createExecution(), firstNode);
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            Node node = execution.getNode();
            Node firstNode = node.getNodes().get(0);
            this.executeLoop(execution, firstNode);
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
        }
    }

    private void executeLoop(BpelExecution execution, Node node) {
        boolean whileResult = this.condition.getEvaluator().evaluateBoolean(execution);
        if (whileResult) {
            Misc.fastDynamicLog(LOG, Level.FINE, "while condition : %s evaluated to true", this.condition);
            execution.execute(node);
        } else {
            execution.end(ExecutionState.ended);
            BpelExecution whileExecution = execution.getParent();
            whileExecution.removeExecution(execution);
            whileExecution.signal("finished");
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.WHILE;
    }
}

