/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.element.FromTo;
import org.ow2.orchestra.definition.element.Literal;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class From
extends FromTo {
    private static final Logger LOG = Logger.getLogger(From.class.getName());
    protected Literal literal;
    protected String endpointReference;

    public Object getValue(BpelExecution execution) {
        Misc.fastDynamicLog(LOG, Level.FINE, "Getting from value of %s", this);
        if (this.variant == Variant.LITERAL) {
            return this.literal.getValue();
        }
        if (this.variant == Variant.EXPR) {
            return this.expression.getEvaluator().evaluate(execution);
        }
        if (this.variant == Variant.VAR) {
            VariableRuntime var = execution.getVariableByName(this.variable);
            if (this.part == null) {
                if (this.variableQuery == null) {
                    return var.getValue();
                }
                Element value = (Element)var.getValue();
                return this.variableQuery.getEvaluator().evaluate(value, execution);
            }
            if (this.variableQuery == null) {
                return ((MessageVariable)var.getValue()).getPartValue(this.part);
            }
            Element value = ((MessageVariable)var.getValue()).getPartValue(this.part);
            return this.variableQuery.getEvaluator().evaluate(value, execution);
        }
        if (this.variant == Variant.PROP) {
            Element contextNode = this.getContextNode(execution);
            return this.variableQuery.getEvaluator().evaluate(contextNode, execution);
        }
        if (this.variant == Variant.PLNK) {
            if (this.endpointReference != null) {
                if (this.endpointReference.equals("myRole")) {
                    return execution.getPartnerLinkRuntime(this.partnerLink).getMyRoleEndPointReference(execution);
                }
                return execution.getPartnerLinkRuntime(this.partnerLink).getPartnerRoleEndPointReference(execution);
            }
            return execution.getPartnerLinkRuntime(this.partnerLink).getPartnerRoleEndPointReference(execution);
        }
        throw new OrchestraRuntimeException("Unknow VARIANT TYPE : " + (Object)((Object)this.variant));
    }

    public String toString() {
        String result = "<from";
        if (this.variant == Variant.EXPR) {
            result = result + "  expressionLanguage=\"" + this.expression.getLanguage() + "\"";
            result = result + ">";
            result = result + this.expression.getText();
        } else if (this.variant == Variant.VAR) {
            result = result + " variable=\"" + this.variable + "\"";
            if (this.part != null) {
                result = result + " part=\"" + this.part + "\"";
            }
            result = result + ">\n";
            if (this.variableQuery != null) {
                result = result + this.variableQuery.toString();
            }
        } else if (this.variant == Variant.PROP) {
            result = result + " variable=\"" + this.variable + "\"" + " property=\"" + this.property + "\"";
            result = result + ">\n";
        } else if (this.variant == Variant.PLNK) {
            result = result + " partnerLink=\"" + this.partnerLink + "\"" + " endpointReference=\"" + this.endpointReference + "\"";
            result = result + ">\n";
        } else if (this.variant == Variant.LITERAL) {
            result = result + ">\n";
            result = result + this.literal.toString();
        }
        result = result + "</from>\n";
        return result;
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public void setLiteral(Literal literal) {
        this.literal = literal;
    }

    public String getEndpointReference() {
        return this.endpointReference;
    }

    public void setEndpointReference(String endpointReference) {
        this.endpointReference = endpointReference;
    }
}

