/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.ow2.orchestra.definition.Node;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.Misc;

public class OnAlarm {
    private static final Logger LOG = Logger.getLogger(OnAlarm.class.getName());
    private final String uuid = Misc.getUniqueId("onAlarm");
    private Expression durationExpression;
    private Expression deadlineExpression;
    private Expression repeatEveryExpression;
    protected Node activity;

    public void setDurationExpression(Expression durationExpression) {
        this.durationExpression = durationExpression;
    }

    public void setDeadlineExpression(Expression deadlineExpression) {
        this.deadlineExpression = deadlineExpression;
    }

    public void setRepeatEveryExpression(Expression expression) {
        this.repeatEveryExpression = expression;
    }

    public Node getActivity() {
        return this.activity;
    }

    public void setActivity(Node activity) {
        this.activity = activity;
    }

    public Expression getDurationExpression() {
        return this.durationExpression;
    }

    public Expression getDeadlineExpression() {
        return this.deadlineExpression;
    }

    public Expression getRepeatEveryExpression() {
        return this.repeatEveryExpression;
    }

    public static Date computeTimer(BpelExecution execution, Expression deadlineExpression, Expression durationExpression, Expression repeatEveryExpression) {
        Date date = null;
        if (deadlineExpression != null) {
            date = deadlineExpression.getEvaluator().evaluateDeadline(execution).toGregorianCalendar().getTime();
            Misc.fastDynamicLog(LOG, Level.FINE, "waiting until %s", date);
        } else if (durationExpression != null) {
            Duration duration = durationExpression.getEvaluator().evaluateDuration(execution);
            date = new Date();
            duration.addTo(date);
            Misc.fastDynamicLog(LOG, Level.FINE, "waiting for %s", duration);
        } else if (repeatEveryExpression != null) {
            Duration duration = repeatEveryExpression.getEvaluator().evaluateDuration(execution);
            date = new Date();
            duration.addTo(date);
            Misc.fastDynamicLog(LOG, Level.FINE, "waiting for %s", duration);
        } else {
            throw new OrchestraRuntimeException("invalid timer definition");
        }
        return date;
    }

    public String getUuid() {
        return this.uuid;
    }
}

