/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.element.FromTo;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class To
extends FromTo {
    private static final Logger LOG = Logger.getLogger(To.class.getName());

    public void setValue(BpelExecution execution, Object value, boolean keepSrcElementName) {
        Misc.fastDynamicLog(LOG, Level.FINE, "Setting to value of %s", this.toString());
        if (value instanceof MessageVariable) {
            String toMessageVariableName = null;
            if (this.variant == Variant.VAR) {
                toMessageVariableName = this.variable;
            } else if (this.variant == Variant.EXPR) {
                throw new OrchestraRuntimeException("Unsupported from message to Expression");
            }
            VariableRuntime var = execution.getVariableByName(toMessageVariableName);
            MessageVariable fromMessage = (MessageVariable)value;
            var.setValue(fromMessage.duplicate());
            AbstractActivity activity = execution.getNode().getBehaviour();
            var.updated(activity.createRuntimeData(execution));
            return;
        }
        if (this.variant == Variant.EXPR) {
            String variableName = this.expression.getEvaluator().assign(execution, value, keepSrcElementName);
            if (variableName != null) {
                VariableRuntime var = execution.getVariableByName(variableName);
                AbstractActivity activity = execution.getNode().getBehaviour();
                var.updated(activity.createRuntimeData(execution));
            }
        } else if (this.variant == Variant.VAR) {
            Element contextNode;
            VariableRuntime var = execution.getVariableByName(this.variable);
            if (this.part == null) {
                if (this.variableQuery == null) {
                    var.setValue(value, keepSrcElementName);
                } else {
                    contextNode = (Element)var.getValue();
                    this.variableQuery.getEvaluator().assign(contextNode, execution, value, keepSrcElementName);
                }
            } else if (this.variableQuery == null) {
                MessageVariable mess = (MessageVariable)var.getValue();
                mess.setPart(this.part, value, keepSrcElementName);
            } else {
                contextNode = ((MessageVariable)var.getValue()).getPartValue(this.part);
                this.variableQuery.getEvaluator().assign(contextNode, execution, value, keepSrcElementName);
            }
            AbstractActivity activity = execution.getNode().getBehaviour();
            var.updated(activity.createRuntimeData(execution));
        } else if (this.variant == Variant.PROP) {
            Element contextNode = this.getContextNode(execution);
            this.variableQuery.getEvaluator().assign(contextNode, execution, value, keepSrcElementName);
            VariableRuntime var = execution.getVariableByName(this.variable);
            AbstractActivity activity = execution.getNode().getBehaviour();
            var.updated(activity.createRuntimeData(execution));
        } else if (this.variant == Variant.PLNK) {
            PartnerLinkRuntime partnerLinkRuntime = execution.getPartnerLinkRuntime(this.partnerLink);
            AbstractActivity activity = execution.getNode().getBehaviour();
            partnerLinkRuntime.setPartnerRoleEndPointReference((Element)value, activity.createRuntimeData(execution));
        } else {
            throw new OrchestraRuntimeException("Unknow VARIANT TYPE : " + (Object)((Object)this.variant));
        }
    }

    public String toString() {
        String result = "<to";
        if (this.expression != null) {
            result = result + "  expressionLanguage=\"" + this.expression.getLanguage() + "\"";
        }
        if (this.variable != null) {
            result = result + "  variable=\"" + this.variable + "\"";
        }
        if (this.part != null) {
            result = result + "  part=\"" + this.part + "\"";
        }
        if (this.property != null) {
            result = result + "  property=\"" + this.property + "\"";
        }
        if (this.partnerLink != null) {
            result = result + "  partnerLink=\"" + this.partnerLink + "\"";
        }
        result = result + ">\n";
        if (this.variableQuery != null) {
            result = result + this.variableQuery.toString();
        }
        if (this.expression != null) {
            result = result + this.expression.toString();
        }
        result = result + "</to>\n";
        return result;
    }
}

