/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.env.xml.EnvironmentFactoryParser;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.persistence.db.DbHistory;
import org.ow2.orchestra.persistence.db.DbJournal;
import org.ow2.orchestra.persistence.log.LoggerArchiver;
import org.ow2.orchestra.persistence.log.LoggerRecorder;
import org.ow2.orchestra.services.Archiver;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.services.handlers.FinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.UndeployedProcessHandler;
import org.ow2.orchestra.services.handlers.impl.ExitInstanceDeadJobHandler;
import org.ow2.orchestra.services.handlers.impl.NoOpFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.NoOpUndeployedProcessHandler;
import org.ow2.orchestra.services.impl.DbRepository;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.services.impl.UnsupportedInvoker;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.services.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEnvXMLGenerator {
    public static final String CORE_HB_CONF_NAME = "hibernate-configuration:core";
    public static final String CORE_HB_SESSION_FACTORY_NAME = "hibernate-session-factory:core";
    public static final String CORE_HB_SESSION_NAME = "hibernate-session:core";
    public static final String CORE_RUNTIME_SESSION_NAME = "runtime-session:core";
    public static final String CORE_QUERIER_SESSION_NAME = "querier-session:core";
    public static final String JOURNAL_HB_CONF_NAME = "hibernate-configuration:journal";
    public static final String JOURNAL_HB_SESSION_FACTORY_NAME = "hibernate-session-factory:journal";
    public static final String JOURNAL_HB_SESSION_NAME = "hibernate-session:journal";
    public static final String JOURNAL_QUERIER_SESSION_NAME = "querier-session:journal";
    public static final String HISTORY_HB_CONF_NAME = "hibernate-configuration:history";
    public static final String HISTORY_HB_SESSION_FACTORY_NAME = "hibernate-session-factory:history";
    public static final String HISTORY_HB_SESSION_NAME = "hibernate-session:history";
    public static final String HISTORY_QUERIER_SESSION_NAME = "querier-session:history";
    public static final String ORCHESTRA_PROPERTIES = "orchestra-properties";
    private final Map<String, String> applicationVariables = new LinkedHashMap<String, String>();
    private final Map<String, String> blockVariables = new LinkedHashMap<String, String>();
    private Class<? extends Repository> repositoryType = null;
    private Class<? extends Publisher> publisherType = null;
    private Class<? extends Invoker> invokerType = null;
    private String recorderXml = "";
    private String archiverXml = "";
    private String querierXml = "";
    private String fihXml = "";
    private String uphXml = "";
    private String deadJobHandlerXml = "";

    public DefaultEnvXMLGenerator(String hibernateRelativePath, InstallationType installationType) {
        this.setPublisherType(PublisherImpl.class);
        this.setInvokerType(UnsupportedInvoker.class);
        this.setApplicationEntry(ORCHESTRA_PROPERTIES, "<properties name='orchestra-properties' resource='orchestra.properties' />");
        String hibernateCoreConfigXml = "";
        hibernateCoreConfigXml = hibernateCoreConfigXml + "<hibernate-configuration name='hibernate-configuration:core'>";
        hibernateCoreConfigXml = hibernateRelativePath == null || hibernateRelativePath.length() == 0 ? hibernateCoreConfigXml + "<properties resource='hibernate.properties' />" : hibernateCoreConfigXml + "<properties file='" + hibernateRelativePath + "hibernate.properties' />";
        hibernateCoreConfigXml = hibernateCoreConfigXml + "<mappings resource='hibernate/bpel.core.mappings.xml' />";
        if (installationType.journalUsesCoreSession) {
            hibernateCoreConfigXml = hibernateCoreConfigXml + "<mappings resource='hibernate/bpel.monitoring.mappings.xml' />";
        }
        hibernateCoreConfigXml = hibernateCoreConfigXml + "<cache-configuration resource='hibernate/bpel.cache.definition.xml' usage='nonstrict-read-write' />";
        hibernateCoreConfigXml = hibernateCoreConfigXml + "<!-- cache-configuration for runtime data. Must be used with a replicated cache when used in cluster -->";
        hibernateCoreConfigXml = hibernateCoreConfigXml + "<!-- <cache-configuration resource='hibernate/bpel.cache.runtime.xml' usage='read-write' /> -->";
        hibernateCoreConfigXml = hibernateCoreConfigXml + "</hibernate-configuration>";
        this.setApplicationEntry(CORE_HB_CONF_NAME, hibernateCoreConfigXml);
        this.setApplicationEntry(CORE_HB_SESSION_FACTORY_NAME, "<hibernate-session-factory name='hibernate-session-factory:core' configuration='hibernate-configuration:core' init='eager' />");
        this.setBlockEntry(CORE_HB_SESSION_NAME, "<hibernate-session name='hibernate-session:core' factory='hibernate-session-factory:core' />");
        this.setBlockEntry(CORE_RUNTIME_SESSION_NAME, "<runtime-db-session name='runtime-session:core' session='hibernate-session:core'/>");
        String commandServiceConfigXml = "<command-service>";
        commandServiceConfigXml = commandServiceConfigXml + "<retry-interceptor retries='10' delay-factor='4' delay='100' max-delay='10000' />";
        commandServiceConfigXml = commandServiceConfigXml + "<environment-interceptor />";
        commandServiceConfigXml = commandServiceConfigXml + "<standard-transaction-interceptor />";
        commandServiceConfigXml = commandServiceConfigXml + "</command-service>";
        this.setApplicationEntry("command-service", commandServiceConfigXml);
        this.setApplicationEntry("invoke-executor", "<invoke-executor threads='10' />");
        this.setApplicationEntry("job-executor", "<job-executor threads='10' auto-start='false' lock='180000' limit-job-per-instance='false' />");
        this.setRepositoryType(DbRepository.class);
        this.setBlockEntry("transaction", "<transaction />");
        this.setBlockEntry("timer_session", "<timer-session retries='50' />");
        this.setBlockEntry("message_session", "<message-session retries='50' use-fair-scheduling='false' />");
        this.setBlockEntry("job-session", "<job-db-session session='hibernate-session:core' />");
        this.setRecorderType(LoggerRecorder.class);
        this.setFinishedInstanceHandlerType(NoOpFinishedInstanceHandler.class);
        this.setUndeployedProcessHandlerType(NoOpUndeployedProcessHandler.class);
        this.setDeadJobHandlerType(ExitInstanceDeadJobHandler.class);
        this.setArchiverType(LoggerArchiver.class);
        if (installationType.hasJournal) {
            this.addJournal(hibernateRelativePath, installationType.journalUsesCoreSession);
        }
        if (installationType.hasHistory) {
            this.addHistory(hibernateRelativePath);
        }
    }

    private void addJournal(String hibernateRelativePath, boolean journalUsesCoreSession) {
        if (journalUsesCoreSession) {
            this.setBlockEntry("journal", "<journal name='journal' class='" + DbJournal.class.getName() + "'>" + "<arg><ref object='" + CORE_QUERIER_SESSION_NAME + "' /></arg></journal>");
            this.setBlockEntry(CORE_QUERIER_SESSION_NAME, "<querier-db-session name='querier-session:core' session='hibernate-session:core'/>");
        } else {
            String hibernateJournalConfigXml = "";
            hibernateJournalConfigXml = hibernateJournalConfigXml + "<hibernate-configuration name='hibernate-configuration:journal'>";
            hibernateJournalConfigXml = hibernateRelativePath == null || hibernateRelativePath.length() == 0 ? hibernateJournalConfigXml + "<properties resource='hibernate-journal.properties' />" : hibernateJournalConfigXml + "<properties file='" + hibernateRelativePath + "hibernate-journal.properties' />";
            hibernateJournalConfigXml = hibernateJournalConfigXml + "<mappings resource='hibernate/bpel.monitoring.mappings.xml' />";
            hibernateJournalConfigXml = hibernateJournalConfigXml + "</hibernate-configuration>";
            this.setApplicationEntry(JOURNAL_HB_CONF_NAME, hibernateJournalConfigXml);
            this.setApplicationEntry(JOURNAL_HB_SESSION_FACTORY_NAME, "<hibernate-session-factory name='hibernate-session-factory:journal' configuration='hibernate-configuration:journal' init='eager' />");
            this.setBlockEntry(JOURNAL_HB_SESSION_NAME, "<hibernate-session name='hibernate-session:journal' factory='hibernate-session-factory:journal' />");
            this.setBlockEntry(JOURNAL_QUERIER_SESSION_NAME, "<querier-db-session name='querier-session:journal' session='hibernate-session:journal'/>");
            this.setBlockEntry("journal", "<journal name='journal' class='" + DbJournal.class.getName() + "'>" + "<arg><ref object='" + JOURNAL_QUERIER_SESSION_NAME + "' /></arg></journal>");
        }
        this.addRecorderType("<ref object='journal' />");
        this.addQuerierType("<ref object='journal' />");
    }

    private void addHistory(String hibernateRelativePath) {
        this.setBlockEntry("history", "<history name='history' class='" + DbHistory.class.getName() + "'>" + "<arg><ref object='" + HISTORY_QUERIER_SESSION_NAME + "' /></arg></history>");
        this.addArchiverType("<ref object='history' />");
        this.addQuerierType("<ref object='history' />");
        String hibernateHistoryConfigXml = "";
        hibernateHistoryConfigXml = hibernateHistoryConfigXml + "<hibernate-configuration name='hibernate-configuration:history'>";
        hibernateHistoryConfigXml = hibernateRelativePath == null || hibernateRelativePath.length() == 0 ? hibernateHistoryConfigXml + "<properties resource='hibernate-history.properties' />" : hibernateHistoryConfigXml + "<properties file='" + hibernateRelativePath + "hibernate-history.properties' />";
        hibernateHistoryConfigXml = hibernateHistoryConfigXml + "<mappings resource='hibernate/bpel.monitoring.mappings.xml' />";
        hibernateHistoryConfigXml = hibernateHistoryConfigXml + "</hibernate-configuration>";
        this.setApplicationEntry(HISTORY_HB_CONF_NAME, hibernateHistoryConfigXml);
        this.setApplicationEntry(HISTORY_HB_SESSION_FACTORY_NAME, "<hibernate-session-factory name='hibernate-session-factory:history' configuration='hibernate-configuration:history' init='eager' />");
        this.setBlockEntry(HISTORY_HB_SESSION_NAME, "<hibernate-session name='hibernate-session:history' factory='hibernate-session-factory:history' />");
        this.setBlockEntry(HISTORY_QUERIER_SESSION_NAME, "<querier-db-session name='querier-session:history' session='hibernate-session:history'/>");
    }

    public DefaultEnvXMLGenerator() {
        this(null, InstallationType.INTERNAL_JOURNAL_NO_HISTORY);
    }

    public String createEnvironmentXml() {
        if (this.invokerType == null) {
            throw new OrchestraRuntimeException("Error while creating environment xml : invoker is null");
        }
        if (this.publisherType == null) {
            throw new OrchestraRuntimeException("Error while creating environment xml : publisher is null");
        }
        if (this.repositoryType == null) {
            throw new OrchestraRuntimeException("Error while creating environment xml : repository is null");
        }
        if (this.recorderXml.length() > 0) {
            this.setBlockEntry("recorder", "<chainer name='recorder'>" + this.recorderXml + "</chainer>");
        }
        if (this.archiverXml.length() > 0) {
            this.setBlockEntry("archiver", "<chainer name='archiver'>" + this.archiverXml + "</chainer>");
        }
        this.setBlockEntry("queryList", "<queryApi name='queryList'>" + this.querierXml + "</queryApi>");
        this.setBlockEntry("finished-instance-handler", this.fihXml);
        this.setBlockEntry("undeployed-process-handler", this.uphXml);
        this.setApplicationEntry("dead-job-handler", this.deadJobHandlerXml);
        StringBuffer result = new StringBuffer();
        result.append("<environment-definition>");
        result.append("<environment-factory>");
        for (String entry : this.applicationVariables.values()) {
            result.append(entry);
        }
        result.append("<repository class='" + this.repositoryType.getName() + "' />" + "<publisher class='" + this.publisherType.getName() + "' />" + "<invoker class='" + this.invokerType.getName() + "' name='" + "serviceInvoker" + "'/>" + "</environment-factory><environment>");
        for (String entry : this.blockVariables.values()) {
            result.append(entry);
        }
        result.append("</environment></environment-definition>");
        Document doc = XmlUtil.getDocumentFromString(result.toString(), false);
        return XmlUtil.toString(doc);
    }

    public EnvironmentFactory createEnvironmentFactory() {
        EnvironmentFactory environmentFactory = EnvironmentFactoryParser.parseEnvironmentFactoryFromXmlString(this.createEnvironmentXml());
        return environmentFactory;
    }

    private static String getObjectDecl(String key, Class<?> classToUse) {
        return "    <object name='" + key + "' class='" + classToUse.getName() + "' init='eager'/>";
    }

    private static String getObjectDeclWithFields(String key, Class<?> classToUse, String[] fieldKeys, String[] refKeys) {
        if (fieldKeys.length != refKeys.length) {
            throw new RuntimeException("Error : fieldKeys and refKeys don't have the same number of elements");
        }
        StringBuffer result = new StringBuffer("<object name='" + key + "' class='" + classToUse.getName() + "' init='eager'>");
        for (int i = 0; i < fieldKeys.length; ++i) {
            result.append("<field name='" + fieldKeys[i] + "'><ref object='" + refKeys[i] + "' /></field>");
        }
        result.append("</object>");
        return result.toString();
    }

    public String setApplicationEntry(String name, String xml) {
        return this.applicationVariables.put(name, xml);
    }

    public String setApplicationEntry(String name, Class<?> classToUse) {
        String xml = DefaultEnvXMLGenerator.getObjectDecl(name, classToUse);
        return this.setApplicationEntry(name, xml);
    }

    public String setApplicationEntry(String name, Class<?> classToUse, String[] fieldKeys, String[] refKeys) {
        String xml = DefaultEnvXMLGenerator.getObjectDeclWithFields(name, classToUse, fieldKeys, refKeys);
        return this.setApplicationEntry(name, xml);
    }

    public String setBlockEntry(String name, String xml) {
        return this.blockVariables.put(name, xml);
    }

    public String setBlockEntry(String name, Class<?> classToUse) {
        String xml = DefaultEnvXMLGenerator.getObjectDecl(name, classToUse);
        return this.setBlockEntry(name, xml);
    }

    public String setBlockEntry(String name, Class<?> classToUse, String[] fieldKeys, String[] refKeys) {
        String xml = DefaultEnvXMLGenerator.getObjectDeclWithFields(name, classToUse, fieldKeys, refKeys);
        return this.setBlockEntry(name, xml);
    }

    public void setRepositoryType(Class<? extends Repository> repositoryType) {
        this.repositoryType = repositoryType;
    }

    public void setPublisherType(Class<? extends Publisher> publisherType) {
        this.publisherType = publisherType;
    }

    public void setInvokerType(Class<? extends Invoker> invokerType) {
        this.invokerType = invokerType;
    }

    public void setRecorderType(Class<? extends Recorder> ... recorderClasses) {
        this.recorderXml = "";
        for (Class<? extends Recorder> recorderClass : recorderClasses) {
            this.addRecorderType("<recorder class='" + recorderClass.getName() + "' />");
        }
    }

    public void addRecorderType(String recorderDeclaration) {
        this.recorderXml = this.recorderXml + recorderDeclaration;
    }

    public void setArchiverType(Class<? extends Archiver> ... archiverClasses) {
        this.archiverXml = "";
        for (Class<? extends Archiver> archiverClass : archiverClasses) {
            this.addArchiverType("<archiver class='" + archiverClass.getName() + "' />");
        }
    }

    public void addArchiverType(String archiverDeclaration) {
        this.archiverXml = this.archiverXml + archiverDeclaration;
    }

    public void addQuerierType(String querierDeclaration) {
        this.querierXml = this.querierXml + querierDeclaration;
    }

    public void setFinishedInstanceHandlerType(Class<? extends FinishedInstanceHandler> ... fihClasses) {
        this.fihXml = "<chainer name='finished-instance-handler'>";
        for (Class<? extends FinishedInstanceHandler> fihClass : fihClasses) {
            this.fihXml = this.fihXml + "<finished-instance-handler class='" + fihClass.getName() + "' />";
        }
        this.fihXml = this.fihXml + "</chainer>";
    }

    public void setUndeployedProcessHandlerType(Class<? extends UndeployedProcessHandler> ... uphClasses) {
        this.uphXml = "<chainer name='undeployed-process-handler'>";
        for (Class<? extends UndeployedProcessHandler> uphClass : uphClasses) {
            this.uphXml = this.uphXml + "<undeployed-process-handler class='" + uphClass.getName() + "' />";
        }
        this.uphXml = this.uphXml + "</chainer>";
    }

    public void setDeadJobHandlerType(Class<? extends DeadJobHandler> ... djhClasses) {
        this.deadJobHandlerXml = "";
        if (djhClasses.length > 1) {
            this.deadJobHandlerXml = "<chainer>";
        }
        for (Class<? extends DeadJobHandler> djhClass : djhClasses) {
            this.deadJobHandlerXml = this.deadJobHandlerXml + "<dead-job-handler class='" + djhClass.getName() + "' />";
        }
        if (djhClasses.length > 1) {
            this.deadJobHandlerXml = "</chainer>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallationType {
        NO_JOURNAL(false, false, false),
        INTERNAL_JOURNAL_WITH_HISTORY(true, true, true),
        EXTERNAL_JOURNAL_WITH_HISTORY(true, true, false),
        INTERNAL_JOURNAL_NO_HISTORY(true, false, true),
        EXTERNAL_JOURNAL_NO_HISTORY(true, false, false);

        private final boolean hasJournal;
        private final boolean hasHistory;
        private final boolean journalUsesCoreSession;

        private InstallationType(boolean hasJournal, boolean hasHistory, boolean journalUsesCoreSession) {
            this.hasJournal = hasJournal;
            this.hasHistory = hasHistory;
            this.journalUsesCoreSession = journalUsesCoreSession;
        }

        public boolean hasJournal() {
            return this.hasJournal;
        }

        public boolean hasHistory() {
            return this.hasHistory;
        }
    }
}

