/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Context;
import org.ow2.orchestra.env.Descriptor;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.WireDefinition;
import org.ow2.orchestra.env.WireException;
import org.ow2.orchestra.env.WireObjectEventInfo;
import org.ow2.orchestra.util.Closable;
import org.ow2.orchestra.util.DefaultObservable;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireContext
extends DefaultObservable
implements Context,
Closable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(WireContext.class.getName());
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_CLOSE = "close";
    protected String name = "wire-context";
    protected transient ClassLoader classLoader;
    protected WireDefinition wireDefinition;
    private Set<String> underConstruction = null;
    private Map<String, PendingInitialization> pendingInitializations = null;
    private Map<String, Object> underInitialization = null;
    private Map<String, Object> cache = null;
    private Map<String, Exception> exceptions = null;

    public WireContext() {
    }

    public WireContext(WireDefinition wireDefinition) {
        this(wireDefinition, null, null, false);
    }

    public WireContext(WireDefinition wireDefinition, String name) {
        this.wireDefinition = wireDefinition;
        this.name = name;
        this.classLoader = wireDefinition != null ? wireDefinition.getClassLoader() : null;
        this.create();
    }

    public WireContext(WireDefinition wireDefinition, String name, Environment environment, boolean delayCreate) {
        this.wireDefinition = wireDefinition;
        this.name = name;
        ClassLoader classLoader = this.classLoader = wireDefinition != null ? wireDefinition.getClassLoader() : null;
        if (!delayCreate) {
            this.create();
        }
    }

    public static Object create(Descriptor descriptor) {
        WireContext wireContext = new WireContext();
        return wireContext.create(descriptor, false);
    }

    public void create() {
        Misc.fastDynamicLog(LOG, Level.FINEST, "creating %s", this.name);
        this.initializeEagerObjects();
        this.fire(EVENT_OPEN, null);
    }

    void initializeEagerObjects() {
        List<String> eagerInitObjectNames;
        if (this.wireDefinition != null && (eagerInitObjectNames = this.wireDefinition.getEagerInitNames()) != null) {
            for (String eagerInitObjectName : eagerInitObjectNames) {
                Descriptor descriptor = this.wireDefinition.getDescriptor(eagerInitObjectName);
                if (!descriptor.isEagerInit()) continue;
                Misc.fastDynamicLog(LOG, Level.FINE, "eagerly initializing %s", eagerInitObjectName);
                this.get(eagerInitObjectName, descriptor.isDelayable());
            }
            while (!this.hasObjectUnderConstruction() && !this.hasObjectUnderInitialization() && this.hasPendingInitializations()) {
                this.processPendingInitializations();
            }
        }
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }

    @Override
    public Set<String> keys() {
        Map<String, Descriptor> descriptors;
        HashSet<String> keys = new HashSet<String>();
        if (this.cache != null) {
            keys.addAll(this.cache.keySet());
        }
        if (this.wireDefinition != null && (descriptors = this.wireDefinition.getDescriptors()) != null) {
            keys.addAll(descriptors.keySet());
        }
        return keys;
    }

    @Override
    public boolean has(String objectName) {
        return this.hasCached(objectName) || this.wireDefinition != null && this.wireDefinition.hasDescriptor(objectName);
    }

    @Override
    public Object get(String objectName) {
        return this.get(objectName, false);
    }

    @Override
    public synchronized Object set(String objectName, Object object) {
        if (objectName == null) {
            throw new WireException("objectName is null");
        }
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
        this.fireObjectEvent("set", objectName, object);
        return this.cache.put(objectName, object);
    }

    public Object remove(String objectName) {
        Object removed = null;
        if (this.cache != null) {
            removed = this.cache.remove(objectName);
            this.fireObjectEvent("remove", objectName, removed);
        }
        return removed;
    }

    public synchronized void clear() {
        if (this.cache != null) {
            HashSet<String> objectsInCache = new HashSet<String>(this.cache.keySet());
            for (String object : objectsInCache) {
                this.remove(object);
            }
        }
    }

    @Override
    public synchronized void close() {
        Misc.fastDynamicLog(LOG, Level.FINEST, "closing %s...", this.name);
        this.fire(EVENT_CLOSE, null);
    }

    public synchronized Object get(String objectName, boolean isDelayable) {
        if (this.hasException(objectName)) {
            throw new WireException("getting " + objectName + " previously resulted in an exception", this.exceptions.get(objectName));
        }
        if (this.hasCached(objectName)) {
            Object object = this.cache.get(objectName);
            Misc.fastDynamicLog(LOG, Level.FINEST, "delivering %s", objectName);
            return object;
        }
        Object constructed = this.getConstructed(objectName);
        if (isDelayable && null != constructed) {
            Object object = constructed;
            Misc.fastDynamicLog(LOG, Level.FINEST, "providing already constructed %s", objectName);
            return object;
        }
        if (this.wireDefinition.hasDescriptor(objectName)) {
            if (this.isUnderConstruction(objectName) || this.isUnderInitialization(objectName)) {
                throw new WireException("circular dependency for " + objectName);
            }
            return this.create(objectName, isDelayable);
        }
        Environment environment = Environment.getCurrent();
        if (environment != null) {
            Misc.fastDynamicLog(LOG, Level.FINEST, "delivering %s from environment", objectName);
            return environment.get(objectName);
        }
        Misc.fastDynamicLog(LOG, Level.FINEST, "delivering null for undefined object %s", objectName);
        return null;
    }

    protected Object create(String objectName, boolean isDelayable) {
        Descriptor descriptor = this.wireDefinition.getDescriptor(objectName);
        return this.create(descriptor, isDelayable);
    }

    public Object create(Descriptor descriptor, boolean isDelayable) {
        Object object = null;
        object = this.construct(descriptor);
        this.initialize(object, descriptor, isDelayable);
        this.processPendingInitializations();
        return object;
    }

    Object construct(Descriptor descriptor) {
        Object object;
        String objectName = descriptor.getName();
        if (objectName != null) {
            this.fireObjectEvent("constructing", objectName, null);
            if (this.underConstruction == null) {
                this.underConstruction = new HashSet<String>();
            }
            this.underConstruction.add(objectName);
            Misc.fastDynamicLog(LOG, Level.FINEST, "constructing %s", objectName);
        }
        try {
            object = descriptor.construct(this);
        }
        catch (RuntimeException e) {
            this.addException(descriptor, e);
            throw e;
        }
        if (objectName != null) {
            this.underConstruction.remove(objectName);
        }
        return object;
    }

    void initialize(Object object, Descriptor descriptor, boolean isDelayable) {
        InitializationType initializationType = this.getInitializationType(object, descriptor, isDelayable);
        if (initializationType == InitializationType.IMMEDIATE) {
            this.performInitialization(object, descriptor);
        } else if (initializationType == InitializationType.DELAYEBLE) {
            this.addPendingInitialization(object, descriptor);
        } else {
            String objectName = descriptor.getName();
            if (objectName != null) {
                this.set(objectName, object);
            }
        }
    }

    InitializationType getInitializationType(Object object, Descriptor descriptor, boolean isDelayable) {
        if (object == null) {
            return InitializationType.NONE;
        }
        if (isDelayable && descriptor.isDelayable()) {
            return InitializationType.DELAYEBLE;
        }
        return InitializationType.IMMEDIATE;
    }

    void performInitialization(Object object, Descriptor descriptor) {
        String objectName = descriptor.getName();
        if (objectName != null) {
            this.fireObjectEvent("initializing", objectName, object);
            if (this.underInitialization == null) {
                this.underInitialization = new HashMap<String, Object>();
            }
            this.underInitialization.put(objectName, object);
            Misc.fastDynamicLog(LOG, Level.FINEST, "initializing %s", objectName);
        }
        try {
            descriptor.initialize(object, this);
        }
        catch (RuntimeException e) {
            this.addException(descriptor, e);
            throw e;
        }
        if (objectName != null) {
            this.underInitialization.remove(objectName);
            this.fireObjectEvent("constructed", objectName, object);
            this.set(objectName, object);
        }
    }

    void addPendingInitialization(Object object, Descriptor descriptor) {
        if (this.pendingInitializations == null) {
            this.pendingInitializations = new HashMap<String, PendingInitialization>();
        }
        this.pendingInitializations.put(descriptor.getName(), new PendingInitialization(object, descriptor));
    }

    void processPendingInitializations() {
        if (this.pendingInitializations != null) {
            HashSet<PendingInitialization> pendingInitializationValues = new HashSet<PendingInitialization>(this.pendingInitializations.values());
            for (PendingInitialization pi : pendingInitializationValues) {
                String objectName = pi.initializable.getName();
                if ((pi = this.pendingInitializations.remove(objectName)) == null) continue;
                this.performInitialization(pi.object, pi.initializable);
            }
        }
    }

    boolean hasPendingInitializations() {
        return this.pendingInitializations != null && !this.pendingInitializations.isEmpty();
    }

    public boolean hasCached(String objectName) {
        return this.cache != null && this.cache.containsKey(objectName);
    }

    Object getConstructed(String objectName) {
        Object constructed = null;
        if (this.pendingInitializations != null && this.pendingInitializations.containsKey(objectName)) {
            constructed = this.pendingInitializations.get(objectName).object;
        } else if (this.underInitialization != null && this.underInitialization.containsKey(objectName)) {
            constructed = this.underInitialization.get(objectName);
        }
        return constructed;
    }

    protected void fireObjectEvent(String eventName, String objectName, Object object) {
        Descriptor descriptor;
        Map<String, Descriptor> descriptors;
        WireObjectEventInfo wireEvent = null;
        if (this.wireDefinition != null && (descriptors = this.wireDefinition.getDescriptors()) != null && (descriptor = descriptors.get(objectName)) != null) {
            wireEvent = new WireObjectEventInfo(eventName, objectName, object);
            descriptor.fire(eventName, wireEvent);
        }
        if (this.listeners != null) {
            wireEvent = new WireObjectEventInfo(eventName, objectName, object);
            this.fire(eventName, wireEvent);
        }
    }

    boolean hasObjectUnderConstruction() {
        return this.underConstruction != null && !this.underConstruction.isEmpty();
    }

    boolean hasObjectUnderInitialization() {
        return this.underInitialization != null && !this.underInitialization.isEmpty();
    }

    boolean isUnderConstruction(String objectName) {
        return this.underConstruction != null && this.underConstruction.contains(objectName);
    }

    boolean isUnderInitialization(String objectName) {
        return this.underInitialization != null && this.underInitialization.containsKey(objectName);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public boolean hasClassLoader() {
        return this.classLoader != null;
    }

    @Override
    public <T> T get(Class<T> type) {
        String descrName;
        if (this.wireDefinition != null && (descrName = this.wireDefinition.getDescriptorName(type)) != null) {
            return (T)this.get(descrName);
        }
        return null;
    }

    protected boolean hasException(String objectName) {
        return this.exceptions != null && this.exceptions.containsKey(objectName);
    }

    protected void addException(Descriptor descriptor, Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new HashMap<String, Exception>();
        }
        this.exceptions.put(descriptor.getName(), exception);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WireDefinition getWireDefinition() {
        return this.wireDefinition;
    }

    public void setWireDefinition(WireDefinition wireDefinition) {
        this.wireDefinition = wireDefinition;
    }

    private static class PendingInitialization {
        private final Object object;
        private final Descriptor initializable;

        public PendingInitialization(Object object, Descriptor descriptor) {
            this.object = object;
            this.initializable = descriptor;
        }

        public String toString() {
            String objectName = this.initializable.getName();
            return "PendingInitialization[" + (objectName != null ? objectName + "|" : "") + this.object + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InitializationType {
        NONE,
        IMMEDIATE,
        DELAYEBLE;

    }
}

