/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.binding;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.env.Descriptor;
import org.ow2.orchestra.env.binding.WireDescriptorBinding;
import org.ow2.orchestra.env.descriptor.CollectionDescriptor;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.PvmXmlUtil;
import org.ow2.orchestra.util.ReflectUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionBinding
extends WireDescriptorBinding {
    public AbstractCollectionBinding(String tagName) {
        super(tagName);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        Boolean isSynchronized;
        CollectionDescriptor descriptor = this.createDescriptor();
        String className = XmlUtil.attribute(element, "class");
        if (AbstractCollectionBinding.verify(className, this.getCollectionInterface(), parse, parser)) {
            descriptor.setClassName(className);
        }
        if ((isSynchronized = PvmXmlUtil.attributeBoolean(element, "synchronized", false, parse)) != null) {
            descriptor.setSynchronized(isSynchronized);
        }
        ArrayList<Descriptor> valueDescriptors = new ArrayList<Descriptor>();
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null) {
            for (Element valueElement : elements) {
                Descriptor valueDescriptor = (Descriptor)parser.parseElement(valueElement, parse, "descriptor");
                if (valueDescriptor == null) continue;
                valueDescriptors.add(valueDescriptor);
            }
        }
        descriptor.setValueDescriptors(valueDescriptors);
        return descriptor;
    }

    public static boolean verify(String className, Class<?> collectionInterface, Parse parse, Parser parser) {
        if (className == null) {
            return false;
        }
        try {
            Class<?> collectionClass = ReflectUtil.loadClass(parse.getClassLoader(), className);
            if (collectionInterface.isAssignableFrom(collectionClass)) {
                return true;
            }
            parse.addProblem("class " + className + " is not a " + collectionInterface.getName());
        }
        catch (OrchestraRuntimeException e) {
            parse.addProblem("class " + className + " could not be found");
        }
        return false;
    }

    protected abstract Class<?> getCollectionInterface();

    protected abstract CollectionDescriptor createDescriptor();
}

