/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.binding;

import org.ow2.orchestra.env.binding.WireDescriptorBinding;
import org.ow2.orchestra.env.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.env.descriptor.FalseDescriptor;
import org.ow2.orchestra.env.descriptor.IntegerDescriptor;
import org.ow2.orchestra.env.descriptor.JobExecutorDescriptor;
import org.ow2.orchestra.env.descriptor.ObjectDescriptor;
import org.ow2.orchestra.env.descriptor.ReferenceDescriptor;
import org.ow2.orchestra.env.descriptor.StringDescriptor;
import org.ow2.orchestra.env.descriptor.TrueDescriptor;
import org.ow2.orchestra.env.operation.InvokeOperation;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.services.jobexecutor.jdk.JdkJobExecutor;
import org.ow2.orchestra.services.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.util.PvmXmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class JobExecutorBinding
extends WireDescriptorBinding {
    public JobExecutorBinding() {
        super("job-executor");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        String type = "default";
        if (element.hasAttribute("type")) {
            type = element.getAttribute("type");
        }
        JobExecutorDescriptor descriptor = null;
        if (type.equals("default")) {
            descriptor = new JobExecutorDescriptor((Class<? extends JobExecutor>)PvmJobExecutor.class);
            this.parseIntAttribute(element, "idle-max", descriptor, "idleMillisMax", parse);
            this.parseIntAttribute(element, "history", descriptor, "historySize", parse);
            this.parseIntAttribute(element, "threads", descriptor, "nbrOfThreads", parse);
        } else if (type.equals("jdk")) {
            descriptor = new JobExecutorDescriptor((Class<? extends JobExecutor>)JdkJobExecutor.class);
        } else {
            parse.addProblem("JobExecutor type: " + type + " is not supported.", element.getAttributeNode("type") == null ? element : element.getAttributeNode("type"));
            return null;
        }
        if (element.hasAttribute("command-service")) {
            descriptor.addInjection("commandService", new ReferenceDescriptor(element.getAttribute("command-service")));
        } else {
            descriptor.addInjection("commandService", new ContextTypeRefDescriptor(CommandService.class));
        }
        if (element.hasAttribute("dead-job-handler")) {
            descriptor.addInjection("deadJobHandler", new ReferenceDescriptor(element.getAttribute("dead-job-handler")));
        } else {
            descriptor.addInjection("deadJobHandler", new ContextTypeRefDescriptor(DeadJobHandler.class));
        }
        if (element.hasAttribute("name")) {
            descriptor.addInjection("name", new StringDescriptor(element.getAttribute("name")));
        }
        this.parseIntAttribute(element, "idle", descriptor, "idleMillis", parse);
        this.parseIntAttribute(element, "lock", descriptor, "lockMillis", parse);
        if (PvmXmlUtil.attributeBoolean(element, "limit-job-per-instance", false, parse, false).booleanValue()) {
            descriptor.addInjection("limitSameInstanceJobs", new TrueDescriptor());
        } else {
            descriptor.addInjection("limitSameInstanceJobs", new FalseDescriptor());
        }
        if (PvmXmlUtil.attributeBoolean(element, "auto-start", false, parse, true).booleanValue()) {
            InvokeOperation invokeStartOperation = new InvokeOperation();
            invokeStartOperation.setMethodName("start");
            descriptor.addOperation(invokeStartOperation);
            descriptor.setAutoStart(true);
        }
        return descriptor;
    }

    private void parseIntAttribute(Element element, String attributeName, ObjectDescriptor descriptor, String fieldName, Parse parse) {
        Integer intValue = PvmXmlUtil.attributeInteger(element, attributeName, false, parse);
        if (intValue != null) {
            descriptor.addInjection(fieldName, new IntegerDescriptor(intValue));
        }
    }
}

