/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.binding;

import org.ow2.orchestra.env.binding.WireDescriptorBinding;
import org.ow2.orchestra.env.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.env.descriptor.FalseDescriptor;
import org.ow2.orchestra.env.descriptor.IntegerDescriptor;
import org.ow2.orchestra.env.descriptor.ObjectDescriptor;
import org.ow2.orchestra.env.descriptor.TransactionRefDescriptor;
import org.ow2.orchestra.env.descriptor.TrueDescriptor;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutorMessageSession;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class MessageSessionBinding
extends WireDescriptorBinding {
    public MessageSessionBinding() {
        super("message-session");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        objectDescriptor.setClassName(JobExecutorMessageSession.class.getName());
        objectDescriptor.addInjection("transaction", new TransactionRefDescriptor());
        objectDescriptor.addInjection("jobDbSession", new ContextTypeRefDescriptor(JobDbSession.class));
        if (element.hasAttribute("retries")) {
            String retriesText = element.getAttribute("retries");
            try {
                Integer retries = Integer.valueOf(retriesText);
                objectDescriptor.addInjection("defaultRetries", new IntegerDescriptor(retries));
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse retries " + retriesText, element.getAttributeNode("retries"));
            }
        }
        if (element.hasAttribute("use-fair-scheduling")) {
            String useFairSchedulingText = element.getAttribute("use-fair-scheduling");
            Boolean useFairScheduling = XmlUtil.parseBooleanValue(useFairSchedulingText);
            if (useFairScheduling != null) {
                if (useFairScheduling.booleanValue()) {
                    objectDescriptor.addInjection("useFairScheduling", new TrueDescriptor());
                } else {
                    objectDescriptor.addInjection("useFairScheduling", new FalseDescriptor());
                }
            } else {
                parse.addProblem("couldn't parse use-fair-scheduling " + useFairSchedulingText, element.getAttributeNode("use-fair-scheduling"));
            }
        }
        return objectDescriptor;
    }
}

