/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.binding;

import org.ow2.orchestra.env.binding.WireInterceptorBinding;
import org.ow2.orchestra.env.descriptor.RetryInterceptorDescriptor;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class RetryInterceptorBinding
extends WireInterceptorBinding {
    public RetryInterceptorBinding() {
        super("retry-interceptor");
    }

    protected RetryInterceptorDescriptor createRetryInterceptorDescriptor() {
        return new RetryInterceptorDescriptor();
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        String delayText;
        RetryInterceptorDescriptor retryInterceptorDescriptor = this.createRetryInterceptorDescriptor();
        if (element.hasAttribute("retries")) {
            String retriesText = element.getAttribute("retries");
            try {
                int retries = Integer.parseInt(retriesText);
                retryInterceptorDescriptor.setRetries(retries);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse retries " + retriesText, element.getAttributeNode("retries"));
            }
        }
        if (element.hasAttribute("delay")) {
            delayText = element.getAttribute("delay");
            try {
                long delay = Long.parseLong(delayText);
                retryInterceptorDescriptor.setDelay(delay);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay " + delayText, element.getAttributeNode("delay"));
            }
        }
        if (element.hasAttribute("max-delay")) {
            delayText = element.getAttribute("max-delay");
            try {
                long delay = Long.parseLong(delayText);
                retryInterceptorDescriptor.setMaxDelay(delay);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay " + delayText, element.getAttributeNode("max-delay"));
            }
        }
        if (element.hasAttribute("delay-factor")) {
            String delayFactorText = element.getAttribute("delay-factor");
            try {
                int delayFactor = Integer.parseInt(delayFactorText);
                retryInterceptorDescriptor.setDelayFactor(delayFactor);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay-factor " + delayFactorText, element.getAttributeNode("delay-factor"));
            }
        }
        return retryInterceptorDescriptor;
    }
}

