/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.binding;

import org.ow2.orchestra.env.binding.WireDescriptorBinding;
import org.ow2.orchestra.env.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.env.descriptor.EnvironmentTypeRefDescriptor;
import org.ow2.orchestra.env.descriptor.IntegerDescriptor;
import org.ow2.orchestra.env.descriptor.ObjectDescriptor;
import org.ow2.orchestra.env.descriptor.TransactionRefDescriptor;
import org.ow2.orchestra.services.jobexecutor.JobDbSession;
import org.ow2.orchestra.services.jobexecutor.JobExecutor;
import org.ow2.orchestra.services.jobexecutor.JobExecutorTimerSession;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

public class TimerSessionBinding
extends WireDescriptorBinding {
    public TimerSessionBinding() {
        super("timer-session");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor objectDescriptor = new ObjectDescriptor();
        objectDescriptor.setClassName(JobExecutorTimerSession.class.getName());
        objectDescriptor.addInjection("transaction", new TransactionRefDescriptor());
        objectDescriptor.addInjection("jobExecutor", new EnvironmentTypeRefDescriptor(JobExecutor.class));
        objectDescriptor.addInjection("jobDbSession", new ContextTypeRefDescriptor(JobDbSession.class));
        if (element.hasAttribute("retries")) {
            String retriesText = element.getAttribute("retries");
            try {
                Integer retries = Integer.valueOf(retriesText);
                objectDescriptor.addInjection("defaultRetries", new IntegerDescriptor(retries));
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse retries " + retriesText, element.getAttributeNode("retries"));
            }
        }
        return objectDescriptor;
    }
}

