/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.descriptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.WireContext;
import org.ow2.orchestra.env.WireException;
import org.ow2.orchestra.env.descriptor.AbstractDescriptor;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentTypeRefDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(EnvironmentTypeRefDescriptor.class.getName());
    private final Class<?> type;

    public EnvironmentTypeRefDescriptor(Class<?> type) {
        this.type = type;
    }

    @Override
    public Object construct(WireContext wireContext) {
        Misc.fastDynamicLog(LOG, Level.FINEST, "looking up %s by type in environment", this.type);
        if (this.type != null) {
            Environment environment = Environment.getCurrent();
            if (environment == null) {
                throw new WireException("no environment to search an object of type " + this.type.getName());
            }
            return environment.get(this.type);
        }
        return null;
    }
}

