/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.descriptor;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.WireContext;
import org.ow2.orchestra.env.WireDefinition;
import org.ow2.orchestra.env.WireException;
import org.ow2.orchestra.env.descriptor.AbstractDescriptor;
import org.ow2.orchestra.persistence.tx.HibernateSessionResource;
import org.ow2.orchestra.persistence.tx.StandardTransaction;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(HibernateSessionDescriptor.class.getName());
    protected String factoryName;
    protected boolean useCurrent = false;
    protected boolean tx = true;
    protected boolean close = true;
    protected String standardTransactionName;
    protected String connectionName;

    @Override
    public Object construct(WireContext wireContext) {
        Environment environment = Environment.getCurrent();
        if (environment == null) {
            throw new WireException("no environment");
        }
        SessionFactory sessionFactory = null;
        sessionFactory = this.factoryName != null ? (SessionFactory)wireContext.get(this.factoryName) : environment.get(SessionFactory.class);
        if (sessionFactory == null) {
            throw new WireException("couldn't find hibernate-session-factory " + (this.factoryName != null ? "'" + this.factoryName + "'" : "by type ") + "to open a hibernate-session");
        }
        Session session = null;
        if (this.useCurrent) {
            Misc.fastDynamicLog(LOG, Level.FINE, "getting current hibernate session", new Object[0]);
            session = sessionFactory.getCurrentSession();
        } else if (this.connectionName != null) {
            Connection connection = (Connection)wireContext.get(this.connectionName);
            Misc.fastDynamicLog(LOG, Level.FINE, "creating hibernate session with connection %s", connection);
            session = sessionFactory.openSession(connection);
        } else {
            Misc.fastDynamicLog(LOG, Level.FINE, "creating hibernate session", new Object[0]);
            session = sessionFactory.openSession();
        }
        StandardTransaction standardTransaction = environment.get(StandardTransaction.class);
        if (standardTransaction != null) {
            HibernateSessionResource hibernateSessionResource = new HibernateSessionResource(session);
            standardTransaction.enlistResource(hibernateSessionResource);
        }
        return session;
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return org.hibernate.Session.class;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public void setTx(boolean tx) {
        this.tx = tx;
    }

    public void setStandardTransactionName(String standardTransactionName) {
        this.standardTransactionName = standardTransactionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setUseCurrent(boolean useCurrent) {
        this.useCurrent = useCurrent;
    }

    public void setClose(boolean close) {
        this.close = close;
    }
}

