/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.descriptor;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.jmx.StatisticsService;
import org.ow2.orchestra.env.Descriptor;
import org.ow2.orchestra.env.WireContext;
import org.ow2.orchestra.env.WireDefinition;
import org.ow2.orchestra.env.WireException;
import org.ow2.orchestra.env.descriptor.AbstractDescriptor;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Listener;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSessionFactoryDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(HibernateSessionFactoryDescriptor.class.getName());
    private String configurationName;
    private Descriptor configurationDescriptor;

    @Override
    public Object construct(WireContext wireContext) {
        Configuration configuration = null;
        configuration = this.configurationName != null ? (Configuration)wireContext.get(this.configurationName) : (this.configurationDescriptor != null ? (Configuration)wireContext.create(this.configurationDescriptor, false) : wireContext.get(Configuration.class));
        if (configuration == null) {
            throw new WireException("couldn't find configuration");
        }
        SessionFactory sessionFactory = configuration.buildSessionFactory();
        wireContext.addListener(new SessionFactoryCloser(sessionFactory));
        Properties orchestraProperties = (Properties)wireContext.get("orchestra-properties");
        if (orchestraProperties != null) {
            ObjectName on;
            String jmxObjectName = orchestraProperties.getProperty("orchestra.jmx.objectName");
            String domainName = jmxObjectName.substring(0, jmxObjectName.indexOf(":"));
            String mbeanName = this.getName();
            mbeanName = mbeanName.replace(",", "_");
            mbeanName = mbeanName.replace("=", "_");
            mbeanName = mbeanName.replace(":", "_");
            mbeanName = mbeanName.replace("'", "_");
            mbeanName = mbeanName.replace("*", "_");
            mbeanName = mbeanName.replace("?", "_");
            Hashtable<String, String> tb = new Hashtable<String, String>();
            tb.put("type", "Hibernate");
            tb.put("name", mbeanName);
            try {
                on = new ObjectName(domainName, tb);
                StatisticsService stats = new StatisticsService();
                stats.setSessionFactory(sessionFactory);
                ManagementFactory.getPlatformMBeanServer().registerMBean(stats, on);
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("couldn't register mbeans", e);
            }
            wireContext.addListener(new SessionFactoryMBeanCloser(on));
        }
        return sessionFactory;
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return SessionFactory.class;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfigurationDescriptor(Descriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public static class SessionFactoryCloser
    implements Listener {
        private final SessionFactory sessionFactory;

        public SessionFactoryCloser(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                Misc.fastDynamicLog(LOG, Level.FINE, "closing hibernate session factory", new Object[0]);
                this.sessionFactory.close();
            }
        }
    }

    public static class SessionFactoryMBeanCloser
    implements Listener {
        private final ObjectName objectName;

        public SessionFactoryMBeanCloser(ObjectName on) {
            this.objectName = on;
        }

        public void event(Object source, String eventName, Object info) {
            if ("close".equals(eventName)) {
                try {
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
                }
                catch (Exception e) {
                    throw new OrchestraRuntimeException("Exception while unregistering mbean", e);
                }
            }
        }
    }
}

