/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.descriptor;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.ow2.orchestra.env.WireContext;
import org.ow2.orchestra.env.WireDefinition;
import org.ow2.orchestra.env.WireException;
import org.ow2.orchestra.env.descriptor.MapDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDescriptor
extends MapDescriptor {
    private static final long serialVersionUID = 1L;
    protected String url;
    protected String file;
    protected String resource;
    protected boolean isXml;

    public PropertiesDescriptor() {
        this.className = Properties.class.getName();
    }

    @Override
    public Object construct(WireContext wireContext) {
        return new Properties();
    }

    @Override
    public void initialize(Object object, WireContext wireContext) {
        String description = null;
        try {
            InputStream inputStream;
            if (this.url != null) {
                description = "url " + this.url;
                inputStream = new URL(this.url).openStream();
                this.load(object, inputStream);
            }
            if (this.file != null) {
                description = "file " + this.file;
                inputStream = new FileInputStream(this.file);
                this.load(object, inputStream);
            }
            if (this.resource != null) {
                description = "resource " + this.resource;
                inputStream = wireContext.getClassLoader().getResourceAsStream(this.resource);
                if (inputStream == null) {
                    throw new RuntimeException("resource " + this.resource + " doesn't exist");
                }
                this.load(object, inputStream);
            }
        }
        catch (Exception e) {
            throw new WireException("couldn't read properties from " + description, e);
        }
        super.initialize(object, wireContext);
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return Properties.class;
    }

    protected void load(Object object, InputStream inputStream) throws Exception {
        Properties properties = (Properties)object;
        if (this.isXml) {
            properties.loadFromXML(inputStream);
        } else {
            properties.load(inputStream);
            inputStream.close();
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isXml() {
        return this.isXml;
    }

    public void setXml(boolean isXml) {
        this.isXml = isXml;
    }
}

