/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.env.operation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.env.WireContext;
import org.ow2.orchestra.env.WireException;
import org.ow2.orchestra.env.descriptor.ArgDescriptor;
import org.ow2.orchestra.env.descriptor.ObjectDescriptor;
import org.ow2.orchestra.env.operation.AbstractOperation;
import org.ow2.orchestra.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 1L;
    private String methodName = null;
    private List<ArgDescriptor> argDescriptors = null;

    @Override
    public void apply(Object target, WireContext wireContext) {
        try {
            Object[] args = ObjectDescriptor.getArgs(wireContext, this.argDescriptors);
            Class<?> clazz = target.getClass();
            Method method = ReflectUtil.findMethod(clazz, this.methodName, this.argDescriptors, args);
            if (method == null) {
                throw new WireException("method " + ReflectUtil.getSignature(this.methodName, this.argDescriptors, args) + " unavailable");
            }
            ReflectUtil.invoke(method, target, args);
        }
        catch (WireException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WireException("couldn't invoke method " + this.methodName + ": " + e.getMessage(), e);
        }
    }

    public void addArgDescriptor(ArgDescriptor argDescriptor) {
        if (this.argDescriptors == null) {
            this.argDescriptors = new ArrayList<ArgDescriptor>();
        }
        this.argDescriptors.add(argDescriptor);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<ArgDescriptor> getArgDescriptors() {
        return this.argDescriptors;
    }

    public void setArgDescriptors(List<ArgDescriptor> argDescriptors) {
        this.argDescriptors = argDescriptors;
    }
}

